//[okio](../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[atomicMove](atomic-move.md)



# atomicMove  
[common]  
Content  
abstract fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  
More info  


Moves source to target in-place if the underlying file system supports it. If target exists, it is first removed. If source == target, this operation does nothing. This may be used to move a file or a directory.



**Only as Atomic as the Underlying File System Supports**



FAT and NTFS file systems cannot atomically move a file over an existing file. If the target file already exists, the move is performed into two steps:

<ol><li>Atomically delete the target file.</li><li>Atomically rename the source file to the target file.</li></ol>

The delete step and move step are each atomic but not atomic in aggregate! If this process crashes, the host operating system crashes, or the hardware fails it is possible that the delete step will succeed and the rename will not.



**Entire-file or nothing**



These are the possible results of this operation:

<ul><li>This operation returns normally, the source file is absent, and the target file contains the     data previously held by the source file. This is the success case.</li><li>The operation throws an [IOException](../-i-o-exception/index.md) and the file system is unchanged. For example, this     occurs if this process lacks permissions to perform the move.</li><li>This operation throws an [IOException](../-i-o-exception/index.md), the target file is deleted, but the source file is     unchanged. This is the partial failure case described above and is only possible on     file systems like FAT and NTFS that do not support atomic file replacement. Typically in     such cases this operation won't return at all because the process or operating system has     also crashed.</li></ul>

There is no failure mode where the target file holds a subset of the bytes of the source file. If the rename step cannot be performed atomically, this function will throw an [IOException](../-i-o-exception/index.md) before attempting a move. Typically this occurs if the source and target files are on different physical volumes.



**Non-Atomic Moves**



If you need to move files across volumes, use [copy](copy.md) followed by [delete](delete.md), and change your application logic to recover should the copy step suffer a partial failure.



#### Throws  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[okio.IOException](../-i-o-exception/index.md)| <a name="okio/FileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a><br><br>if the move cannot be performed, or cannot be performed atomically. Moves     fail if the source doesn't exist, if the target is not writable, if the target already     exists and cannot be replaced, or if the move would cause physical or quota limits to be     exceeded. This list of potential problems is not exhaustive.<br><br>
  
|  Name|  Summary| 
|---|---|
  
|  Name|  Summary| 
|---|---|
  


[js, jvm]  
Content  
[js, jvm]  
abstract fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))  
More info  


#### Throws  
  
|  Name|  Summary| 
|---|---|
| <a name="okio/FileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a>[okio.IOException](../-i-o-exception/index.md)| <a name="okio/FileSystem/atomicMove/#okio.Path#okio.Path/PointingToDeclaration/"></a><br><br>if the move cannot be performed, or cannot be performed atomically. Moves     fail if the source doesn't exist, if the target is not writable, if the target already     exists and cannot be replaced, or if the move would cause physical or quota limits to be     exceeded. This list of potential problems is not exhaustive.<br><br>
  
|  Name|  Summary| 
|---|---|
  
|  Name|  Summary| 
|---|---|
  



