//[okio](../../../index.md)/[okio](../index.md)/[ForwardingFileSystem](index.md)/[openReadWrite](open-read-write.md)

# openReadWrite

[common]\
open override fun [openReadWrite](open-read-write.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [FileHandle](../-file-handle/index.md)

Returns a handle to read and write [file](open-read-write.md). This will create the file if it doesn't already exist.

## Parameters

common

| | |
|---|---|
| mustCreate | true to throw an [IOException](../-i-o-exception/index.md) instead of overwriting an existing file.     This is equivalent to O_EXCL on POSIX and CREATE_NEW on Windows. |
| mustExist | true to throw an [IOException](../-i-o-exception/index.md) instead of creating a new file. This is     equivalent to r+ on POSIX and OPEN_EXISTING on Windows. |

## Throws

| | |
|---|---|
| [okio.IOException](../-i-o-exception/index.md) | if [file](open-read-write.md) is not a file, or cannot be accessed. A file cannot be accessed     if the current process doesn't have sufficient reading and writing permissions for [file](open-read-write.md),     if there's a loop of symbolic links, or if any name is too long. |
