//[okio](../../../index.md)/[okio](../index.md)/[Pipe](index.md)

# Pipe

[jvm]\
class [Pipe](index.md)(maxBufferSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html))

A source and a sink that are attached. The sink's output is the source's input. Typically each is accessed by its own thread: a producer thread writes data to the sink and a consumer thread reads data from the source.

This class uses a buffer to decouple source and sink. This buffer has a user-specified maximum size. When a producer thread outruns its consumer the buffer fills up and eventually writes to the sink will block until the consumer has caught up. Symmetrically, if a consumer outruns its producer reads block until there is data to be read. Limits on the amount of time spent waiting for the other party can be configured with [timeouts](../-timeout/index.md) on the source and the sink.

When the sink is closed, source reads will continue to complete normally until the buffer has been exhausted. At that point reads will return -1, indicating the end of the stream. But if the source is closed first, writes to the sink will immediately fail with an [IOException](../-i-o-exception/index.md).

A pipe may be canceled to immediately fail writes to the sink and reads from the source.

## Constructors

| | |
|---|---|
| [Pipe](-pipe.md) | [jvm]<br>fun [Pipe](-pipe.md)(maxBufferSize: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)) |

## Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | [jvm]<br>fun [cancel](cancel.md)()<br>Fail any in-flight and future operations. After canceling: |
| [fold](fold.md) | [jvm]<br>fun [fold](fold.md)(sink: [Sink](../-sink/index.md))<br>Writes any buffered contents of this pipe to sink, then replace this pipe's source with sink. This pipe's source is closed and attempts to read it will throw an [IllegalStateException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-state-exception/index.html). |

## Properties

| Name | Summary |
|---|---|
| [sink](sink.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "sink")<br>val [sink](sink.md): [Sink](../-sink/index.md) |
| [source](source.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = "source")<br>val [source](source.md): [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053) |
