//[okio](../../../index.md)/[okio](../index.md)/[ForwardingTimeout](index.md)

# ForwardingTimeout

[jvm]\
open class [ForwardingTimeout](index.md)(var delegate: [Timeout](../-timeout/index.md)) : [Timeout](../-timeout/index.md)

A [Timeout](../-timeout/index.md) which forwards calls to another. Useful for subclassing.

## Constructors

| | |
|---|---|
| [ForwardingTimeout](-forwarding-timeout.md) | [jvm]<br>constructor(delegate: [Timeout](../-timeout/index.md)) |

## Properties

| Name | Summary |
|---|---|
| [delegate](delegate.md) | [jvm]<br>@get:[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;delegate&quot;)<br>var [delegate](delegate.md): [Timeout](../-timeout/index.md) |

## Functions

| Name | Summary |
|---|---|
| [awaitSignal](await-signal.md) | [jvm]<br>open override fun [awaitSignal](await-signal.md)(condition: [Condition](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/locks/Condition.html))<br>Waits on `monitor` until it is signaled. Throws InterruptedIOException if either the thread is interrupted or if this timeout elapses before `monitor` is signaled. The caller must hold the lock that monitor is bound to. |
| [cancel](cancel.md) | [jvm]<br>open override fun [cancel](cancel.md)()<br>Prevent all current applications of this timeout from firing. Use this when a time-limited operation should no longer be time-limited because the nature of the operation has changed. |
| [clearDeadline](clear-deadline.md) | [jvm]<br>open override fun [clearDeadline](clear-deadline.md)(): [Timeout](../-timeout/index.md)<br>Clears the deadline. |
| [clearTimeout](clear-timeout.md) | [jvm]<br>open override fun [clearTimeout](clear-timeout.md)(): [Timeout](../-timeout/index.md)<br>Clears the timeout. Operating system timeouts may still apply. |
| [deadline](../-timeout/deadline.md) | [jvm]<br>fun [deadline](../-timeout/deadline.md)(duration: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)<br>Set a deadline of now plus `duration` time. |
| [deadlineNanoTime](deadline-nano-time.md) | [jvm]<br>open override fun [deadlineNanoTime](deadline-nano-time.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached.<br>[jvm]<br>open override fun [deadlineNanoTime](deadline-nano-time.md)(deadlineNanoTime: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)): [Timeout](../-timeout/index.md)<br>Sets the [nano time](https://docs.oracle.com/javase/8/docs/api/java/lang/System.html#nanoTime--) when the deadline will be reached. All operations must complete before this time. Use a deadline to set a maximum bound on the time spent on a sequence of operations. |
| [hasDeadline](has-deadline.md) | [jvm]<br>open override fun [hasDeadline](has-deadline.md)(): [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)<br>Returns true if a deadline is enabled. |
| [intersectWith](../-timeout/intersect-with.md) | [jvm]<br>inline fun &lt;[T](../-timeout/intersect-with.md)&gt; [intersectWith](../-timeout/intersect-with.md)(other: [Timeout](../-timeout/index.md), block: () -&gt; [T](../-timeout/intersect-with.md)): [T](../-timeout/intersect-with.md)<br>Applies the minimum intersection between this timeout and `other`, run `block`, then finally rollback this timeout's values. |
| [setDelegate](set-delegate.md) | [jvm]<br>fun [setDelegate](set-delegate.md)(delegate: [Timeout](../-timeout/index.md)): [ForwardingTimeout](index.md) |
| [throwIfReached](throw-if-reached.md) | [jvm]<br>open override fun [throwIfReached](throw-if-reached.md)()<br>Throws an InterruptedIOException if the deadline has been reached or if the current thread has been interrupted. This method doesn't detect timeouts; that should be implemented to asynchronously abort an in-progress operation. |
| [timeout](timeout.md) | [jvm]<br>open override fun [timeout](timeout.md)(timeout: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), unit: [TimeUnit](https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/TimeUnit.html)): [Timeout](../-timeout/index.md)<br>Wait at most `timeout` time before aborting an operation. Using a per-operation timeout means that as long as forward progress is being made, no sequence of operations will fail. |
| [timeout](../-timeout/-companion/timeout.md) | [jvm]<br>fun [Timeout](../-timeout/index.md).[timeout](../-timeout/-companion/timeout.md)(duration: [Duration](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.time/-duration/index.html)): [Timeout](../-timeout/index.md)<br>fun [Timeout](../-timeout/index.md).[timeout](../-timeout/-companion/timeout.md)(timeout: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html), unit: [DurationUnit](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.time/-duration-unit/index.html)): [Timeout](../-timeout/index.md) |
| [timeoutNanos](timeout-nanos.md) | [jvm]<br>open override fun [timeoutNanos](timeout-nanos.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>Returns the timeout in nanoseconds, or `0` for no timeout. |
| [waitUntilNotified](wait-until-notified.md) | [jvm]<br>open override fun [waitUntilNotified](wait-until-notified.md)(monitor: [Any](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-any/index.html))<br>Waits on `monitor` until it is notified. Throws InterruptedIOException if either the thread is interrupted or if this timeout elapses before `monitor` is notified. The caller must be synchronized on `monitor`. |