//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)/[list](list.md)

# list

[common]\
expect abstract fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[Path](../-path/index.md)&gt;

Returns the children of [dir](list.md). The returned list is sorted using natural ordering. If [dir](list.md) is a relative path, the returned elements will also be relative paths. If it is an absolute path, the returned elements will also be absolute paths.

Note that a path does not need to be a [directory](../-file-metadata/is-directory.md) for this function to return successfully. For example, mounted storage devices may have child files but do not identify themselves as directories.

#### Throws

| | |
|---|---|
| [IOException](../-i-o-exception/index.md) | if [dir](list.md) does not exist or cannot be listed. A path cannot be listed if the     current process doesn't have access to [dir](list.md), or if there's a loop of symbolic links, or if     any name is too long. |

[js, jvm, native, wasm]\
[js, jvm, native, wasm]\
actual abstract fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.collections/-list/index.html)&lt;[Path](../-path/index.md)&gt;