//[okio](../../../index.md)/[okio](../index.md)/[BufferedSource](index.md)/[select](select.md)

# select

[common]\
expect abstract fun [select](select.md)(options: [Options](../-options/index.md)): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)

Finds the first string in `options` that is a prefix of this buffer, consumes it from this buffer, and returns its index. If no byte string in `options` is a prefix of this buffer this returns -1 and no bytes are consumed.

This can be used as an alternative to [readByteString](read-byte-string.md) or even [readUtf8](read-utf8.md) if the set of expected values is known in advance.

```kotlin
Options FIELDS = Options.of(
    ByteString.encodeUtf8("depth="),
    ByteString.encodeUtf8("height="),
    ByteString.encodeUtf8("width="));

Buffer buffer = new Buffer()
    .writeUtf8("width=640\n")
    .writeUtf8("height=480\n");

assertEquals(2, buffer.select(FIELDS));
assertEquals(640, buffer.readDecimalLong());
assertEquals('\n', buffer.readByte());
assertEquals(1, buffer.select(FIELDS));
assertEquals(480, buffer.readDecimalLong());
assertEquals('\n', buffer.readByte());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [select](select.md)(options: Options): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)
