//[okio](../../../index.md)/[okio](../index.md)/[FileSystem](index.md)

# FileSystem

[common]\
expect abstract class [FileSystem](index.md)

Read and write access to a hierarchical collection of files, addressed by [paths](../-path/index.md). This is a natural interface to the current computer's local file system.

Other implementations are possible:

- 
   `FakeFileSystem` is an in-memory file system suitable for testing. Note that this class is     included in the `okio-fakefilesystem` artifact.
- 
   [ForwardingFileSystem](../-forwarding-file-system/index.md) is a file system decorator. Use it to apply monitoring, encryption,     compression, or filtering to another file system.
- 
   A ZIP file system could provide access to the contents of a `.zip` file.

For improved capability and testability, consider structuring your classes to dependency inject a `FileSystem` rather than using `FileSystem.SYSTEM` directly.

Small API

 ---------

This interface is deliberately limited in which features it supports.

It is not suitable for high-latency or unreliable remote file systems. It lacks support for retries, timeouts, cancellation, and bulk operations.

It cannot create special file types like hard links, pipes, or mounts. Reading or writing these files works as if they were regular files.

It cannot read or write file access control features like the UNIX `chmod` and Windows access control lists. It does honor these controls and will fail with an [IOException](../-i-o-exception/index.md) if privileges are insufficient!

It cannot lock files or check which files are locked.

It cannot watch the file system for changes.

Applications that need rich file system features should use another API!

Multiplatform

 -------------

This class supports a matrix of Kotlin platforms (JVM, Kotlin/Native, Kotlin/JS) and operating systems (Linux, macOS, and Windows). It attempts to balance working similarly across platforms with being consistent with the local operating system.

This is a blocking API which limits its applicability on concurrent Node.js services. File operations will block the event loop (and all JavaScript execution!) until they complete.

It supports the path schemes of both Windows (like `C:\Users`) and UNIX (like `/home`). Note that path resolution rules differ by platform.

Differences vs. Java IO APIs

 ----------------------------

The `java.io.File` class is Java's original file system API. The `delete` and `renameTo` methods return false if the operation failed. The `list` method returns null if the file isn't a directory or could not be listed. This class always throws an [IOException](../-i-o-exception/index.md) when an operation doesn't succeed.

The `java.nio.Path` and `java.nio.Files` classes are the entry points of Java's new file system API. Each `Path` instance is scoped to a particular file system, though that is often implicit because the `Paths.get()` function automatically uses the default (ie. system) file system. In Okio's API paths are just identifiers; you must use a specific `FileSystem` object to do I/O with.

[js, jvm, native]\
actual abstract class [FileSystem](index.md)

## Constructors

| | |
|---|---|
| [FileSystem](-file-system.md) | [js, jvm, native]<br>fun [FileSystem](-file-system.md)()<br>[common]<br>expect fun [FileSystem](-file-system.md)() |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, js, jvm, native]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[js, jvm, native]<br>actual object [Companion](-companion/index.md) |

## Functions

| Name | Summary |
|---|---|
| [appendingSink](appending-sink.md) | [jvm, js, native]<br>[jvm]<br>fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)<br>[js, native]<br>actual abstract fun [appendingSink](appending-sink.md)(file: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): Sink<br>[jvm]<br>actual abstract fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sink](../-sink/index.md)<br>[common]<br>expect abstract fun [appendingSink](appending-sink.md)(file: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [Sink](../-sink/index.md)<br>Returns a sink that appends bytes to the end of [file](appending-sink.md), creating it if it doesn't already exist. |
| [atomicMove](atomic-move.md) | [common]<br>expect abstract fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))<br>Moves [source](atomic-move.md) to [target](atomic-move.md) in-place if the underlying file system supports it. If [target](atomic-move.md) exists, it is first removed. If `source == target`, this operation does nothing. This may be used to move a file or a directory.<br>[js, jvm, native]<br>[js, native]<br>actual abstract fun [atomicMove](atomic-move.md)(source: Path, target: Path)<br>[jvm]<br>actual abstract fun [atomicMove](atomic-move.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md)) |
| [canonicalize](canonicalize.md) | [common]<br>expect abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md)<br>Resolves [path](canonicalize.md) against the current working directory and symlinks in this file system. The returned path identifies the same file as [path](canonicalize.md), but with an absolute path that does not include any symbolic links.<br>[js, jvm, native]<br>[js, native]<br>actual abstract fun [canonicalize](canonicalize.md)(path: Path): Path<br>[jvm]<br>actual abstract fun [canonicalize](canonicalize.md)(path: [Path](../-path/index.md)): [Path](../-path/index.md) |
| [copy](copy.md) | [common]<br>expect open fun [copy](copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))<br>Copies all the bytes from the file at [source](copy.md) to the file at [target](copy.md). This does not copy file metadata like last modified time, permissions, or extended attributes.<br>[js, jvm, native]<br>[js, native]<br>actual open fun [copy](copy.md)(source: Path, target: Path)<br>[jvm]<br>actual open fun [copy](copy.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md)) |
| [createDirectories](create-directories.md) | [jvm, js, native]<br>[jvm]<br>fun [createDirectories](create-directories.md)(dir: [Path](../-path/index.md))<br>[js, native]<br>actual fun [createDirectories](create-directories.md)(dir: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>[jvm]<br>actual fun [createDirectories](create-directories.md)(dir: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>[common]<br>expect fun [createDirectories](create-directories.md)(dir: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>Creates a directory at the path identified by [dir](create-directories.md), and any enclosing parent path directories, recursively. |
| [createDirectory](create-directory.md) | [jvm, js, native]<br>[jvm]<br>fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md))<br>[js, native]<br>actual abstract fun [createDirectory](create-directory.md)(dir: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>[jvm]<br>actual abstract fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>[common]<br>expect abstract fun [createDirectory](create-directory.md)(dir: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>Creates a directory at the path identified by [dir](create-directory.md). |
| [createSymlink](create-symlink.md) | [common]<br>expect abstract fun [createSymlink](create-symlink.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md))<br>Creates a symbolic link at [source](create-symlink.md) that resolves to [target](create-symlink.md). If [target](create-symlink.md) is a relative path, it is relative to `source.parent`.<br>[js, jvm, native]<br>[js, native]<br>actual abstract fun [createSymlink](create-symlink.md)(source: Path, target: Path)<br>[jvm]<br>actual abstract fun [createSymlink](create-symlink.md)(source: [Path](../-path/index.md), target: [Path](../-path/index.md)) |
| [delete](delete.md) | [jvm, js, native]<br>[jvm]<br>fun [delete](delete.md)(path: [Path](../-path/index.md))<br>[js, native]<br>actual abstract fun [delete](delete.md)(path: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>[jvm]<br>actual abstract fun [delete](delete.md)(path: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>[common]<br>expect abstract fun [delete](delete.md)(path: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>Deletes the file or directory at [path](delete.md). |
| [deleteRecursively](delete-recursively.md) | [jvm, js, native]<br>[jvm]<br>fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md))<br>[js, native]<br>actual open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: Path, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>[jvm]<br>actual open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>[common]<br>expect open fun [deleteRecursively](delete-recursively.md)(fileOrDirectory: [Path](../-path/index.md), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>Recursively deletes all children of [fileOrDirectory](delete-recursively.md) if it is a directory, then deletes [fileOrDirectory](delete-recursively.md) itself. |
| [exists](exists.md) | [common]<br>expect fun [exists](exists.md)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if [path](exists.md) identifies an object on this file system.<br>[js, jvm, native]<br>[js, native]<br>actual fun [exists](exists.md)(path: Path): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>[jvm]<br>actual fun [exists](exists.md)(path: [Path](../-path/index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [list](list.md) | [common]<br>expect abstract fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Path](../-path/index.md)&gt;<br>Returns the children of [dir](list.md). The returned list is sorted using natural ordering. If [dir](list.md) is a relative path, the returned elements will also be relative paths. If it is an absolute path, the returned elements will also be absolute paths.<br>[js, jvm, native]<br>[js, native]<br>actual abstract fun [list](list.md)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Path&gt;<br>[jvm]<br>actual abstract fun [list](list.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Path](../-path/index.md)&gt; |
| [listOrNull](list-or-null.md) | [common]<br>expect abstract fun [listOrNull](list-or-null.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Path](../-path/index.md)&gt;?<br>Returns the children of the directory identified by [dir](list-or-null.md). The returned list is sorted using natural ordering. If [dir](list-or-null.md) is a relative path, the returned elements will also be relative paths. If it is an absolute path, the returned elements will also be absolute paths.<br>[js, jvm, native]<br>[js, native]<br>actual abstract fun [listOrNull](list-or-null.md)(dir: Path): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Path&gt;?<br>[jvm]<br>actual abstract fun [listOrNull](list-or-null.md)(dir: [Path](../-path/index.md)): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Path](../-path/index.md)&gt;? |
| [listRecursively](list-recursively.md) | [jvm, js, native]<br>[jvm]<br>fun [listRecursively](list-recursively.md)(dir: [Path](../-path/index.md)): [Sequence](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.sequences/-sequence/index.html)&lt;[Path](../-path/index.md)&gt;<br>[js, native]<br>actual open fun [listRecursively](list-recursively.md)(dir: Path, followSymlinks: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sequence](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.sequences/-sequence/index.html)&lt;Path&gt;<br>[jvm]<br>actual open fun [listRecursively](list-recursively.md)(dir: [Path](../-path/index.md), followSymlinks: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sequence](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.sequences/-sequence/index.html)&lt;[Path](../-path/index.md)&gt;<br>[common]<br>expect open fun [listRecursively](list-recursively.md)(dir: [Path](../-path/index.md), followSymlinks: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [Sequence](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.sequences/-sequence/index.html)&lt;[Path](../-path/index.md)&gt;<br>Returns a sequence that **lazily** traverses the children of [dir](list-recursively.md) using repeated calls to [list](list.md). If none of [dir](list-recursively.md)'s children are directories this returns the same elements as [list](list.md). |
| [metadata](metadata.md) | [common]<br>expect fun [metadata](metadata.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)<br>Returns metadata of the file, directory, or object identified by [path](metadata.md).<br>[js, jvm, native]<br>[js, native]<br>actual fun [metadata](metadata.md)(path: Path): FileMetadata<br>[jvm]<br>actual fun [metadata](metadata.md)(path: [Path](../-path/index.md)): FileMetadata |
| [metadataOrNull](metadata-or-null.md) | [common]<br>expect abstract fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): [FileMetadata](../-file-metadata/index.md)?<br>Returns metadata of the file, directory, or object identified by [path](metadata-or-null.md). This returns null if there is no file at [path](metadata-or-null.md).<br>[js, jvm, native]<br>[js, native]<br>actual abstract fun [metadataOrNull](metadata-or-null.md)(path: Path): FileMetadata?<br>[jvm]<br>actual abstract fun [metadataOrNull](metadata-or-null.md)(path: [Path](../-path/index.md)): FileMetadata? |
| [openReadOnly](open-read-only.md) | [common]<br>expect abstract fun [openReadOnly](open-read-only.md)(file: [Path](../-path/index.md)): [FileHandle](../-file-handle/index.md)<br>Returns a handle to read [file](open-read-only.md). This will fail if the file doesn't already exist.<br>[js, jvm, native]<br>[js, native]<br>actual abstract fun [openReadOnly](open-read-only.md)(file: Path): FileHandle<br>[jvm]<br>actual abstract fun [openReadOnly](open-read-only.md)(file: [Path](../-path/index.md)): FileHandle |
| [openReadWrite](open-read-write.md) | [jvm, js, native]<br>[jvm]<br>fun [openReadWrite](open-read-write.md)(file: [Path](../-path/index.md)): FileHandle<br>[js, native]<br>actual abstract fun [openReadWrite](open-read-write.md)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): FileHandle<br>[jvm]<br>actual abstract fun [openReadWrite](open-read-write.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): FileHandle<br>[common]<br>expect abstract fun [openReadWrite](open-read-write.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, mustExist: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [FileHandle](../-file-handle/index.md)<br>Returns a handle to read and write [file](open-read-write.md). This will create the file if it doesn't already exist. |
| [read](read.md) | [common]<br>expect inline fun &lt;[T](read.md)&gt; [read](read.md)(file: [Path](../-path/index.md), readerAction: [BufferedSource](../-buffered-source/index.md).() -&gt; [T](read.md)): [T](read.md)<br>Creates a source to read [file](read.md), executes [readerAction](read.md) to read it, and then closes the source. This is a compact way to read the contents of a file.<br>[js, jvm, native]<br>[js, native]<br>actual inline fun &lt;[T](read.md)&gt; [read](read.md)(file: Path, readerAction: BufferedSource.() -&gt; [T](read.md)): [T](read.md)<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;-read&quot;)<br>actual inline fun &lt;[T](read.md)&gt; [read](read.md)(file: [Path](../-path/index.md), readerAction: [BufferedSource](../-buffered-source/index.md).() -&gt; [T](read.md)): [T](read.md) |
| [sink](sink.md) | [jvm, js, native]<br>[jvm]<br>fun [sink](sink.md)(file: [Path](../-path/index.md)): [Sink](../-sink/index.md)<br>[js, native]<br>actual abstract fun [sink](sink.md)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): Sink<br>[jvm]<br>actual abstract fun [sink](sink.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [Sink](../-sink/index.md)<br>[common]<br>expect abstract fun [sink](sink.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [Sink](../-sink/index.md)<br>Returns a sink that writes bytes to [file](sink.md) from beginning to end. If [file](sink.md) already exists it will be replaced with the new data. |
| [source](source.md) | [common]<br>expect abstract fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md)<br>Returns a source that reads the bytes of [file](source.md) from beginning to end.<br>[js, jvm, native]<br>[js, native]<br>actual abstract fun [source](source.md)(file: Path): Source<br>[jvm]<br>actual abstract fun [source](source.md)(file: [Path](../-path/index.md)): [Source](../-source/index.md#1331753033%2FExtensions%2F1033915053) |
| [write](write.md) | [common]<br>expect inline fun &lt;[T](write.md)&gt; [write](write.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, writerAction: [BufferedSink](../-buffered-sink/index.md).() -&gt; [T](write.md)): [T](write.md)<br>Creates a sink to write [file](write.md), executes [writerAction](write.md) to write it, and then closes the sink. This is a compact way to write a file.<br>[js, jvm, native]<br>[js, native]<br>actual inline fun &lt;[T](write.md)&gt; [write](write.md)(file: Path, mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), writerAction: BufferedSink.() -&gt; [T](write.md)): [T](write.md)<br>[jvm]<br>@[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;-write&quot;)<br>actual inline fun &lt;[T](write.md)&gt; [write](write.md)(file: [Path](../-path/index.md), mustCreate: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), writerAction: [BufferedSink](../-buffered-sink/index.md).() -&gt; [T](write.md)): [T](write.md) |

## Inheritors

| Name |
|---|
| [ForwardingFileSystem](../-forwarding-file-system/index.md) |

## Extensions

| Name | Summary |
|---|---|
| [openZip](../open-zip.md) | [jvm]<br>fun [FileSystem](index.md).[openZip](../open-zip.md)(zipPath: [Path](../-path/index.md)): [FileSystem](index.md) |
