//[okio](../../../index.md)/[okio](../index.md)/[Source](index.md)

# Source

[common]\
interface [Source](index.md) : [Closeable](../-closeable/index.md)

Supplies a stream of bytes. Use this interface to read data from wherever it's located: from the network, storage, or a buffer in memory. Sources may be layered to transform supplied data, such as to decompress, decrypt, or remove protocol framing.

Most applications shouldn't operate on a source directly, but rather on a [BufferedSource](../-buffered-source/index.md) which is both more efficient and more convenient. Use [buffer](../buffer.md) to wrap any source with a buffer.

Sources are easy to test: just use a [Buffer](../-buffer/index.md) in your tests, and fill it with the data your application is to read.

###  Comparison with InputStream

This interface is functionally equivalent to java.io.InputStream.

`InputStream` requires multiple layers when consumed data is heterogeneous: a `DataInputStream` for primitive values, a `BufferedInputStream` for buffering, and `InputStreamReader` for strings. This library uses `BufferedSource` for all of the above.

Source avoids the impossible-to-implement java.io.InputStream.available method. Instead callers specify how many bytes they [require](../-buffered-source/require.md).

Source omits the unsafe-to-compose java.io.InputStream.mark state that's tracked by `InputStream`; instead, callers just buffer what they need.

When implementing a source, you don't need to worry about the java.io.InputStream.read method that is awkward to implement efficiently and returns one of 257 possible values.

And source has a stronger `skip` method: [BufferedSource.skip](../-buffered-source/skip.md) won't return prematurely.

###  Interop with InputStream

Use source to adapt an `InputStream` to a source. Use BufferedSource.inputStream to adapt a source to an `InputStream`.

## Functions

| Name | Summary |
|---|---|
| [close](close.md) | [common]<br>abstract override fun [close](close.md)()<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [read](read.md) | [common]<br>abstract fun [read](read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to `byteCount` bytes from this and appends them to `sink`. Returns the number of bytes read, or -1 if this source is exhausted. |
| [timeout](timeout.md) | [common]<br>abstract fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |

## Inheritors

| Name |
|---|
| [BufferedSource](../-buffered-source/index.md) |
| [ForwardingSource](../-forwarding-source/index.md) |
| [HashingSource](../-hashing-source/index.md) |
| [CipherSource](../-cipher-source/index.md) |
| [GzipSource](../-gzip-source/index.md) |
| [InflaterSource](../-inflater-source/index.md) |

## Extensions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Source](index.md).[buffer](../buffer.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [cipherSource](../cipher-source.md) | [jvm]<br>fun [Source](index.md#1331753033%2FExtensions%2F1033915053).[cipherSource](../cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](../-cipher-source/index.md)<br>Returns a source that uses [cipher](../cipher-source.md) to encrypt or decrypt this. |
| [gzip](../gzip.md) | [jvm]<br>inline fun [Source](index.md#1331753033%2FExtensions%2F1033915053).[gzip](../gzip.md)(): [GzipSource](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](index.md#1331753033%2FExtensions%2F1033915053) while reading. |
| [hashingSource](../hashing-source.md) | [jvm]<br>fun [Source](index.md#1331753033%2FExtensions%2F1033915053).[hashingSource](../hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [mac](../hashing-source.md) to hash this.<br>[jvm]<br>fun [Source](index.md#1331753033%2FExtensions%2F1033915053).[hashingSource](../hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](../-hashing-source/index.md)<br>Returns a source that uses [digest](../hashing-source.md) to hash this. |
| [inflate](../inflate.md) | [jvm]<br>inline fun [Source](index.md#1331753033%2FExtensions%2F1033915053).[inflate](../inflate.md)(inflater: [Inflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Inflater.html) = Inflater()): [InflaterSource](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](index.md#1331753033%2FExtensions%2F1033915053) while reading. |
