//[okio](../../../index.md)/[okio](../index.md)/[HashingSource](index.md)

# HashingSource

[common]\
expect class [HashingSource](index.md) : [Source](../-source/index.md)

A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](hash.md) to compute the final hash value.

In this example we use `HashingSource` with a [BufferedSource](../-buffered-source/index.md) to make reading from the source easier.

```java
HashingSource hashingSource = HashingSource.sha256(rawSource);
BufferedSource bufferedSource = Okio.buffer(hashingSource);

... // Read all of bufferedSource.

ByteString hash = hashingSource.hash();
```

[jvm]\
actual class [HashingSource](index.md) : [ForwardingSource](../-forwarding-source/index.md), [Source](../-source/index.md#1331753033%2FMain%2F1033915053)

A source that computes a hash of the full stream of bytes it has supplied. To use, create an instance with your preferred hash algorithm. Exhaust the source by reading all of its bytes and then call [hash](hash.md) to compute the final hash value.

In this example we use `HashingSource` with a [BufferedSource](../-buffered-source/index.md) to make reading from the source easier.

```java
HashingSource hashingSource = HashingSource.sha256(rawSource);
BufferedSource bufferedSource = Okio.buffer(hashingSource);

... // Read all of bufferedSource.

ByteString hash = hashingSource.hash();
```

[nonJvm]\
actual class [HashingSource](index.md) : [Source](../-source/index.md)

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common, jvm, nonJvm]<br>[common]<br>expect object [Companion](-companion/index.md)<br>[jvm, nonJvm]<br>actual object [Companion](-companion/index.md) |

## Properties

| Name | Summary |
|---|---|
| [hash](hash.md) | [common, jvm]<br>[common]<br>expect val [hash](hash.md): [ByteString](../-byte-string/index.md)<br>[jvm]<br>@get:[JvmName](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;hash&quot;)<br>actual val [hash](hash.md): [ByteString](../-byte-string/index.md)<br>Returns the hash of the bytes supplied thus far and resets the internal state of this source.<br>[nonJvm]<br>actual val [hash](hash.md): [ByteString](../-byte-string/index.md) |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Source](../-source/index.md).[buffer](../buffer.md)(): [BufferedSource](../-buffered-source/index.md)<br>Returns a new source that buffers reads from `source`. The returned source will perform bulk reads into its in-memory buffer. Use this wherever you read a source to get an ergonomic and efficient access to data. |
| [cipherSource](../cipher-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[cipherSource](../cipher-source.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSource](../-cipher-source/index.md)<br>Returns a source that uses [cipher](../cipher-source.md) to encrypt or decrypt this. |
| close | [nonJvm, common]<br>[nonJvm]<br>open override fun [close](close.md)()<br>[common]<br>abstract override fun [close](../-source/close.md)()<br>Closes this source and releases the resources held by this source. It is an error to read a closed source. It is safe to close a source more than once. |
| [gzip](../gzip.md) | [zlib]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F-1717108311).[gzip](../gzip.md)(): [GzipSource](../-gzip-source/index.md)<br>Returns a [GzipSource](../-gzip-source/index.md) that gzip-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F-1717108311) while reading. |
| [hashingSource](../hashing-source.md) | [jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSource](index.md)<br>Returns a source that uses [digest](../hashing-source.md) to hash this.<br>[jvm]<br>fun [Source](../-source/index.md#1331753033%2FMain%2F1033915053).[hashingSource](../hashing-source.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSource](index.md)<br>Returns a source that uses [mac](../hashing-source.md) to hash this. |
| [inflate](../inflate.md) | [zlib]<br>inline fun [Source](../-source/index.md#1331753033%2FMain%2F-1717108311).[inflate](../inflate.md)(inflater: [Inflater](../-inflater/index.md) = Inflater()): [InflaterSource](../-inflater-source/index.md)<br>Returns an [InflaterSource](../-inflater-source/index.md) that DEFLATE-decompresses this [Source](../-source/index.md#1331753033%2FMain%2F-1717108311) while reading. |
| read | [jvm, nonJvm, common]<br>[jvm]<br>open override fun [read]([jvm]read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[nonJvm]<br>open override fun [read]([non-jvm]read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>[common]<br>abstract fun [read](../-source/read.md)(sink: [Buffer](../-buffer/index.md), byteCount: [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html)<br>Removes at least 1, and up to `byteCount` bytes from this and appends them to `sink`. Returns the number of bytes read, or -1 if this source is exhausted. |
| timeout | [nonJvm, common]<br>[nonJvm]<br>open override fun [timeout](timeout.md)(): [Timeout](../-timeout/index.md)<br>[common]<br>abstract fun [timeout](../-source/timeout.md)(): [Timeout](../-timeout/index.md)<br>Returns the timeout for this source. |
