/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso.pollexor;

import android.net.Uri;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.pollexor.Pollexor;

public class PollexorRequestTransformer
implements Picasso.RequestTransformer {
    private final String host;
    private final String key;

    public PollexorRequestTransformer(String host) {
        this(host, null);
    }

    public PollexorRequestTransformer(String host, String key) {
        this.host = host;
        this.key = key;
    }

    public Request transformRequest(Request request) {
        if (request.resourceId != 0) {
            return request;
        }
        Uri uri = request.uri;
        String scheme = uri.getScheme();
        if (!"https".equals(scheme) && !"http".equals(scheme)) {
            return request;
        }
        if (!request.hasSize()) {
            return request;
        }
        if (request.centerCrop) {
            return request;
        }
        Request.Builder newRequest = request.buildUpon();
        Pollexor pollexor = Pollexor.image((String)uri.toString()).host(this.host);
        if (this.key != null) {
            pollexor.key(this.key);
        }
        pollexor.resize(request.targetWidth, request.targetHeight);
        newRequest.clearResize();
        if (request.centerInside) {
            pollexor.fitIn();
            newRequest.clearCenterInside();
        }
        newRequest.setUri(Uri.parse((String)pollexor.toUrl()));
        return newRequest.build();
    }
}

