/*
 * Decompiled with CFR 0.152.
 */
package com.example.picasso;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;
import java.io.IOException;

public class GrayscaleTransformation
implements Transformation {
    private final Picasso picasso;

    public GrayscaleTransformation(Picasso picasso) {
        this.picasso = picasso;
    }

    public Bitmap transform(Bitmap source) {
        Bitmap noise;
        Bitmap result = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)source.getConfig());
        try {
            noise = this.picasso.load(2130837517).get();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to apply transformation! Missing resource.");
        }
        BitmapShader shader = new BitmapShader(noise, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        ColorMatrixColorFilter filter = new ColorMatrixColorFilter(colorMatrix);
        Paint paint = new Paint(1);
        paint.setColorFilter((ColorFilter)filter);
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        paint.setColorFilter(null);
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY));
        canvas.drawRect(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), paint);
        source.recycle();
        noise.recycle();
        return result;
    }

    public String key() {
        return "grayscaleTransformation()";
    }
}

