/*
 * Decompiled with CFR 0.152.
 */
package com.example.picasso;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.example.picasso.Data;
import com.example.picasso.SampleContactsActivity;
import com.example.picasso.SampleGalleryActivity;
import com.example.picasso.SampleGridViewActivity;
import com.example.picasso.SampleListDetailActivity;
import com.squareup.picasso.Picasso;
import java.util.Random;

final class PicassoSampleAdapter
extends BaseAdapter {
    private static final int NOTIFICATION_ID = 666;
    private final LayoutInflater inflater;

    public PicassoSampleAdapter(Context context) {
        this.inflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return Sample.values().length;
    }

    public Sample getItem(int position) {
        return Sample.values()[position];
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        TextView view = (TextView)convertView;
        if (view == null) {
            view = (TextView)this.inflater.inflate(2130903042, parent, false);
        }
        view.setText((CharSequence)this.getItem(position).name);
        return view;
    }

    static enum Sample {
        GRID_VIEW("Image Grid View", SampleGridViewActivity.class),
        GALLERY("Load from Gallery", SampleGalleryActivity.class),
        CONTACTS("Contact Photos", SampleContactsActivity.class),
        LIST_DETAIL("List / Detail View", SampleListDetailActivity.class),
        SHOW_NOTIFICATION("Sample Notification", null){

            @Override
            public void launch(Activity activity) {
                RemoteViews remoteViews = new RemoteViews(activity.getPackageName(), 2130903040);
                Intent intent = new Intent((Context)activity, SampleGridViewActivity.class);
                NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)activity).setSmallIcon(2130837512).setContentIntent(PendingIntent.getActivity((Context)activity, (int)-1, (Intent)intent, (int)0)).setContent(remoteViews);
                Notification notification = builder.getNotification();
                if (Build.VERSION.SDK_INT <= 10) {
                    notification.contentView = remoteViews;
                }
                NotificationManager notificationManager = (NotificationManager)activity.getSystemService("notification");
                notificationManager.notify(666, notification);
                Picasso.with((Context)activity).load(Data.URLS[new Random().nextInt(Data.URLS.length)]).resizeDimen(2131099652, 2131099652).into(remoteViews, 2131361792, 666, notification);
            }
        };

        private final Class<? extends Activity> activityClass;
        private final String name;

        private Sample(String name, Class<? extends Activity> activityClass) {
            this.activityClass = activityClass;
            this.name = name;
        }

        public void launch(Activity activity) {
            activity.startActivity(new Intent((Context)activity, this.activityClass));
            activity.finish();
        }
    }
}

