/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.moshi.JsonAdapter;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import retrofit.Converter;

final class MoshiConverter<T>
implements Converter<T> {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private JsonAdapter<T> adapter;

    MoshiConverter(JsonAdapter<T> adapter) {
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fromBody(ResponseBody body) throws IOException {
        BufferedSource source = body.source();
        Object object = this.adapter.fromJson(source);
        return (T)object;
        finally {
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
    }

    public RequestBody toBody(T value) {
        Buffer buffer = new Buffer();
        try {
            this.adapter.toJson((BufferedSink)buffer, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.snapshot());
    }
}

