/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ResponseBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit.Converter;
import retrofit.MoshiRequestBodyConverter;
import retrofit.MoshiResponseBodyConverter;

public final class MoshiConverterFactory
extends Converter.Factory {
    private final Moshi moshi;

    public static MoshiConverterFactory create() {
        return MoshiConverterFactory.create(new Moshi.Builder().build());
    }

    public static MoshiConverterFactory create(Moshi moshi) {
        return new MoshiConverterFactory(moshi);
    }

    private MoshiConverterFactory(Moshi moshi) {
        if (moshi == null) {
            throw new NullPointerException("moshi == null");
        }
        this.moshi = moshi;
    }

    public Converter<ResponseBody, ?> fromResponseBody(Type type, Annotation[] annotations) {
        JsonAdapter adapter = this.moshi.adapter(type);
        return new MoshiResponseBodyConverter(adapter);
    }

    public Converter<?, RequestBody> toRequestBody(Type type, Annotation[] annotations) {
        JsonAdapter adapter = this.moshi.adapter(type);
        return new MoshiRequestBodyConverter(adapter);
    }
}

