/*
 * Decompiled with CFR 0.152.
 */
package retrofit.converter;

import com.squareup.wire.Message;
import com.squareup.wire.Wire;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import retrofit.converter.ConversionException;
import retrofit.converter.Converter;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class WireConverter
implements Converter {
    private static final String MIME_TYPE = "application/x-protobuf";
    private final Wire wire;

    public WireConverter() {
        this(new Wire(new Class[0]));
    }

    public WireConverter(Wire wire) {
        this.wire = wire;
    }

    public Object fromBody(TypedInput body, Type type) throws ConversionException {
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("Expected a raw Class<?> but was " + type);
        }
        Class c = (Class)type;
        if (!Message.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Expected a proto message but was " + c.getName());
        }
        if (!MIME_TYPE.equalsIgnoreCase(body.mimeType())) {
            throw new IllegalArgumentException("Expected a proto but was: " + body.mimeType());
        }
        InputStream in = null;
        try {
            in = body.in();
            Message message = this.wire.parseFrom(in, c);
            return message;
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public TypedOutput toBody(Object object) {
        if (!(object instanceof Message)) {
            throw new IllegalArgumentException("Expected a proto message but was " + (object != null ? object.getClass().getName() : "null"));
        }
        byte[] bytes = ((Message)object).toByteArray();
        return new TypedByteArray(MIME_TYPE, bytes);
    }
}

