/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import com.squareup.moshi.JsonAdapter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import retrofit2.Converter;

final class MoshiRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private final JsonAdapter<T> adapter;

    MoshiRequestBodyConverter(JsonAdapter<T> adapter) {
        this.adapter = adapter;
    }

    public RequestBody convert(T value) throws IOException {
        Buffer buffer = new Buffer();
        try {
            this.adapter.toJson((BufferedSink)buffer, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return RequestBody.create((MediaType)MEDIA_TYPE, (ByteString)buffer.readByteString());
    }
}

