/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import com.squareup.spoon.Chmod;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;

public final class Spoon {
    static final String SPOON_SCREENSHOTS = "spoon-screenshots";
    static final String NAME_SEPARATOR = "_";
    static final String TEST_CASE_CLASS = "android.test.InstrumentationTestCase";
    static final String TEST_CASE_METHOD = "runMethod";
    private static final String EXTENSION = ".png";
    private static final String TAG = "Spoon";
    private static final Object LOCK = new Object();
    private static final Pattern TAG_VALIDATION = Pattern.compile("[a-zA-Z0-9_-]+");
    private static boolean outputNeedsClear = true;

    public static void screenshot(Activity activity, String tag) {
        if (!TAG_VALIDATION.matcher(tag).matches()) {
            throw new IllegalArgumentException("Tag must match " + TAG_VALIDATION.pattern() + ".");
        }
        try {
            File screenshotDirectory = Spoon.obtainScreenshotDirectory((Context)activity);
            String screenshotName = System.currentTimeMillis() + NAME_SEPARATOR + tag + EXTENSION;
            Spoon.takeScreenshot(new File(screenshotDirectory, screenshotName), activity);
            Log.d((String)TAG, (String)("Captured screenshot '" + tag + "'."));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to capture screenshot.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void takeScreenshot(File file, final Activity activity) throws IOException {
        DisplayMetrics dm = activity.getResources().getDisplayMetrics();
        final Bitmap bitmap = Bitmap.createBitmap((int)dm.widthPixels, (int)dm.heightPixels, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Spoon.drawDecorViewToBitmap(activity, bitmap);
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            activity.runOnUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Spoon.drawDecorViewToBitmap(activity, bitmap);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                String msg = "Unable to get screenshot " + file.getAbsolutePath();
                Log.e((String)TAG, (String)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            Chmod.chmodPlusR(file);
        }
        finally {
            bitmap.recycle();
            if (fos != null) {
                ((OutputStream)fos).close();
            }
        }
    }

    private static void drawDecorViewToBitmap(Activity activity, Bitmap bitmap) {
        Canvas canvas = new Canvas(bitmap);
        activity.getWindow().getDecorView().draw(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File obtainScreenshotDirectory(Context context) throws IllegalAccessException {
        File screenshotsDir = context.getDir(SPOON_SCREENSHOTS, 1);
        Object object = LOCK;
        synchronized (object) {
            if (outputNeedsClear) {
                Spoon.deletePath(screenshotsDir, false);
                outputNeedsClear = false;
            }
        }
        StackTraceElement testClass = Spoon.findTestClassTraceElement(Thread.currentThread().getStackTrace());
        String className = testClass.getClassName().replaceAll("[^A-Za-z0-9._-]", NAME_SEPARATOR);
        File dirClass = new File(screenshotsDir, className);
        File dirMethod = new File(dirClass, testClass.getMethodName());
        Spoon.createDir(dirMethod);
        return dirMethod;
    }

    static StackTraceElement findTestClassTraceElement(StackTraceElement[] trace) {
        for (int i = trace.length - 1; i >= 0; --i) {
            StackTraceElement element = trace[i];
            if (!TEST_CASE_CLASS.equals(element.getClassName()) || !TEST_CASE_METHOD.equals(element.getMethodName())) continue;
            return trace[i - 3];
        }
        throw new IllegalArgumentException("Could not find test class!");
    }

    private static void createDir(File dir) throws IllegalAccessException {
        File parent = dir.getParentFile();
        if (!parent.exists()) {
            Spoon.createDir(parent);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalAccessException("Unable to create output dir: " + dir.getAbsolutePath());
        }
        Chmod.chmodPlusRWX(dir);
    }

    private static void deletePath(File path, boolean inclusive) {
        File[] children;
        if (path.isDirectory() && (children = path.listFiles()) != null) {
            for (File child : children) {
                Spoon.deletePath(child, true);
            }
        }
        if (inclusive) {
            path.delete();
        }
    }

    private Spoon() {
    }
}

