/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import com.squareup.spoon.Chmod;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;

public final class Spoon {
    static final String SPOON_SCREENSHOTS = "spoon-screenshots";
    static final String NAME_SEPARATOR = "_";
    static final String TEST_CASE_CLASS_JUNIT_3 = "android.test.InstrumentationTestCase";
    static final String TEST_CASE_METHOD_JUNIT_3 = "runMethod";
    static final String TEST_CASE_CLASS_JUNIT_4 = "org.junit.runners.model.FrameworkMethod$1";
    static final String TEST_CASE_METHOD_JUNIT_4 = "runReflectiveCall";
    private static final String EXTENSION = ".png";
    private static final String TAG = "Spoon";
    private static final Object LOCK = new Object();
    private static final Pattern TAG_VALIDATION = Pattern.compile("[a-zA-Z0-9_-]+");
    private static boolean outputNeedsClear = true;

    public static File screenshot(Activity activity, String tag) {
        StackTraceElement testClass = Spoon.findTestClassTraceElement(Thread.currentThread().getStackTrace());
        String className = testClass.getClassName().replaceAll("[^A-Za-z0-9._-]", NAME_SEPARATOR);
        String methodName = testClass.getMethodName();
        return Spoon.screenshot(activity, tag, className, methodName);
    }

    public static File screenshot(Activity activity, String tag, String testClassName, String testMethodName) {
        if (!TAG_VALIDATION.matcher(tag).matches()) {
            throw new IllegalArgumentException("Tag must match " + TAG_VALIDATION.pattern() + ".");
        }
        try {
            File screenshotDirectory = Spoon.obtainScreenshotDirectory(activity.getApplicationContext(), testClassName, testMethodName);
            String screenshotName = System.currentTimeMillis() + NAME_SEPARATOR + tag + EXTENSION;
            File screenshotFile = new File(screenshotDirectory, screenshotName);
            Spoon.takeScreenshot(screenshotFile, activity);
            Log.d((String)TAG, (String)("Captured screenshot '" + tag + "'."));
            return screenshotFile;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to capture screenshot.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void takeScreenshot(File file, final Activity activity) throws IOException {
        View view = activity.getWindow().getDecorView();
        final Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Spoon.drawDecorViewToBitmap(activity, bitmap);
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Spoon.drawDecorViewToBitmap(activity, bitmap);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                String msg = "Unable to get screenshot " + file.getAbsolutePath();
                Log.e((String)TAG, (String)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            Chmod.chmodPlusR(file);
        }
        finally {
            bitmap.recycle();
            if (fos != null) {
                ((OutputStream)fos).close();
            }
        }
    }

    private static void drawDecorViewToBitmap(Activity activity, Bitmap bitmap) {
        Canvas canvas = new Canvas(bitmap);
        activity.getWindow().getDecorView().draw(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File obtainScreenshotDirectory(Context context, String testClassName, String testMethodName) throws IllegalAccessException {
        File screenshotsDir = Build.VERSION.SDK_INT >= 21 ? new File(Environment.getExternalStorageDirectory(), "app_spoon-screenshots") : context.getDir(SPOON_SCREENSHOTS, 1);
        Object object = LOCK;
        synchronized (object) {
            if (outputNeedsClear) {
                Spoon.deletePath(screenshotsDir, false);
                outputNeedsClear = false;
            }
        }
        File dirClass = new File(screenshotsDir, testClassName);
        File dirMethod = new File(dirClass, testMethodName);
        Spoon.createDir(dirMethod);
        return dirMethod;
    }

    static StackTraceElement findTestClassTraceElement(StackTraceElement[] trace) {
        for (int i = trace.length - 1; i >= 0; --i) {
            StackTraceElement element = trace[i];
            if (TEST_CASE_CLASS_JUNIT_3.equals(element.getClassName()) && TEST_CASE_METHOD_JUNIT_3.equals(element.getMethodName())) {
                return trace[i - 3];
            }
            if (!TEST_CASE_CLASS_JUNIT_4.equals(element.getClassName()) || !TEST_CASE_METHOD_JUNIT_4.equals(element.getMethodName())) continue;
            return trace[i - 3];
        }
        throw new IllegalArgumentException("Could not find test class!");
    }

    private static void createDir(File dir) throws IllegalAccessException {
        File parent = dir.getParentFile();
        if (!parent.exists()) {
            Spoon.createDir(parent);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalAccessException("Unable to create output dir: " + dir.getAbsolutePath());
        }
        Chmod.chmodPlusRWX(dir);
    }

    private static void deletePath(File path, boolean inclusive) {
        File[] children;
        if (path.isDirectory() && (children = path.listFiles()) != null) {
            for (File child : children) {
                Spoon.deletePath(child, true);
            }
        }
        if (inclusive) {
            path.delete();
        }
    }

    private Spoon() {
    }
}

