/*
 * Decompiled with CFR 0.152.
 */
package com.example.spoon.ordering.tests;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.IntentFilter;
import android.test.ActivityInstrumentationTestCase2;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.example.spoon.ordering.LoginActivity;
import com.squareup.spoon.Spoon;
import java.util.Random;
import org.fest.assertions.api.ANDROID;

public class LoginActivityTest
extends ActivityInstrumentationTestCase2<LoginActivity> {
    private Instrumentation instrumentation;
    private LoginActivity activity;
    private EditText username;
    private EditText password;
    private Button login;

    public LoginActivityTest() {
        super(LoginActivity.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.instrumentation = this.getInstrumentation();
        this.activity = (LoginActivity)this.getActivity();
        this.username = (EditText)this.activity.findViewById(2130968627);
        this.password = (EditText)this.activity.findViewById(2130968628);
        this.login = (Button)this.activity.findViewById(2130968629);
    }

    public void testEmptyForm_ShowsBothErrors() {
        Spoon.screenshot((Activity)this.activity, (String)"initial_state");
        ANDROID.assertThat((TextView)this.username).hasNoError();
        ANDROID.assertThat((TextView)this.password).hasNoError();
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.login.performClick();
            }
        });
        this.instrumentation.waitForIdleSync();
        Spoon.screenshot((Activity)this.activity, (String)"login_clicked");
        ANDROID.assertThat((TextView)this.username).hasError(2131296287);
        ANDROID.assertThat((TextView)this.password).hasError(2131296287);
    }

    public void testBlankPassword_ShowsError() {
        Spoon.screenshot((Activity)this.activity, (String)"initial_state");
        ANDROID.assertThat((TextView)this.username).hasNoError();
        ANDROID.assertThat((TextView)this.password).hasNoError();
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.username.setText((CharSequence)"jake");
            }
        });
        this.instrumentation.waitForIdleSync();
        Spoon.screenshot((Activity)this.activity, (String)"username_entered");
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.login.performClick();
            }
        });
        Spoon.screenshot((Activity)this.activity, (String)"login_clicked");
        ANDROID.assertThat((TextView)this.username).hasNoError();
        ANDROID.assertThat((TextView)this.password).hasError(2131296287);
    }

    public void testBlankUsername_ShowsError() {
        Spoon.screenshot((Activity)this.activity, (String)"initial_state");
        ANDROID.assertThat((TextView)this.username).hasNoError();
        ANDROID.assertThat((TextView)this.password).hasNoError();
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.password.setText((CharSequence)"secretpassword");
            }
        });
        Spoon.screenshot((Activity)this.activity, (String)"password_entered");
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.login.performClick();
            }
        });
        this.instrumentation.waitForIdleSync();
        Spoon.screenshot((Activity)this.activity, (String)"login_clicked");
        ANDROID.assertThat((TextView)this.username).hasError(2131296287);
        ANDROID.assertThat((TextView)this.password).hasNoError();
    }

    public void testPasswordTooShort_ShowsError() {
        Spoon.screenshot((Activity)this.activity, (String)"initial_state");
        ANDROID.assertThat((TextView)this.username).hasNoError();
        ANDROID.assertThat((TextView)this.password).hasNoError();
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.username.setText((CharSequence)"jake");
                LoginActivityTest.this.password.setText((CharSequence)"secret");
            }
        });
        Spoon.screenshot((Activity)this.activity, (String)"values_entered");
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.login.performClick();
            }
        });
        this.instrumentation.waitForIdleSync();
        Spoon.screenshot((Activity)this.activity, (String)"login_clicked");
        ANDROID.assertThat((TextView)this.username).hasNoError();
        ANDROID.assertThat((TextView)this.password).hasError(2131296288);
    }

    public void testValidValues_StartsNewActivity() {
        IntentFilter filter = new IntentFilter();
        Instrumentation.ActivityMonitor monitor = this.instrumentation.addMonitor(filter, null, false);
        Spoon.screenshot((Activity)this.activity, (String)"initial_state");
        ANDROID.assertThat((TextView)this.username).hasNoError();
        ANDROID.assertThat((TextView)this.password).hasNoError();
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.username.setText((CharSequence)"jake");
                LoginActivityTest.this.password.setText((CharSequence)"secretpassword");
            }
        });
        Spoon.screenshot((Activity)this.activity, (String)"values_entered");
        this.instrumentation.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                LoginActivityTest.this.login.performClick();
            }
        });
        this.instrumentation.waitForIdleSync();
        ANDROID.assertThat((Instrumentation.ActivityMonitor)monitor).hasHits(1);
        Spoon.screenshot((Activity)monitor.getLastActivity(), (String)"next_activity_shown");
        if (new Random().nextInt(4) == 0) {
            throw new AssertionError((Object)"Someone set up us the bomb!");
        }
    }
}

