/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.tools.maven.resolution;

import com.squareup.tools.maven.resolution.ArtifactFetcher;
import com.squareup.tools.maven.resolution.ArtifactFile;
import com.squareup.tools.maven.resolution.FetchStatus;
import com.squareup.tools.maven.resolution.FileSpec;
import com.squareup.tools.maven.resolution.HashingKt;
import com.squareup.tools.maven.resolution.PomFile;
import com.squareup.tools.maven.resolution.UtilsKt;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0003H&J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/squareup/tools/maven/resolution/AbstractArtifactFetcher;", "Lcom/squareup/tools/maven/resolution/ArtifactFetcher;", "cacheDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getCacheDir", "()Ljava/nio/file/Path;", "cachedFileOrFetch", "Lcom/squareup/tools/maven/resolution/FetchStatus;", "fileSpec", "Lcom/squareup/tools/maven/resolution/FileSpec;", "repositories", "", "Lorg/apache/maven/model/Repository;", "fetchArtifact", "artifactFile", "Lcom/squareup/tools/maven/resolution/ArtifactFile;", "fetchFile", "Lcom/squareup/tools/maven/resolution/FetchStatus$RepositoryFetchStatus;", "repository", "path", "fetchFileAndHashes", "fetchPom", "pom", "Lcom/squareup/tools/maven/resolution/PomFile;", "safeWrite", "", "localFile", "body", "", "src_main_java_com_squareup_tools_maven_resolution-resolution"})
public abstract class AbstractArtifactFetcher
implements ArtifactFetcher {
    @NotNull
    private final Path cacheDir;

    @Override
    @NotNull
    public FetchStatus fetchPom(@NotNull PomFile pom, @NotNull List<? extends Repository> repositories) {
        Intrinsics.checkParameterIsNotNull((Object)pom, (String)"pom");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        return this.cachedFileOrFetch(pom, repositories);
    }

    @Override
    @NotNull
    public FetchStatus fetchArtifact(@NotNull ArtifactFile artifactFile, @NotNull List<? extends Repository> repositories) {
        Intrinsics.checkParameterIsNotNull((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        return this.fetchFile(artifactFile, repositories);
    }

    @Override
    @NotNull
    public FetchStatus fetchFile(@NotNull FileSpec artifactFile, @NotNull List<? extends Repository> repositories) {
        Intrinsics.checkParameterIsNotNull((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        return this.cachedFileOrFetch(artifactFile, repositories);
    }

    @NotNull
    public abstract FetchStatus.RepositoryFetchStatus fetchFile(@NotNull FileSpec var1, @NotNull Repository var2, @NotNull Path var3);

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private final FetchStatus cachedFileOrFetch(FileSpec fileSpec, List<? extends Repository> repositories) {
        FetchStatus fetchStatus;
        if (fileSpec.getArtifact().getSnapshot()) {
            return new FetchStatus.RepositoryFetchStatus.FETCH_ERROR(null, "Snapshot versions not supported (" + fileSpec.getArtifact().getCoordinate() + ')', null, null, 13, null);
        }
        if (UtilsKt.getExists(fileSpec.getLocalFile())) {
            UtilsKt.info((Function0<? extends Object>)((Function0)new Function0<String>(fileSpec){
                final /* synthetic */ FileSpec $fileSpec;

                @NotNull
                public final String invoke() {
                    return "Found cached file " + this.$fileSpec.getLocalFile();
                }
                {
                    this.$fileSpec = fileSpec;
                    super(0);
                }
            }));
            return FetchStatus.RepositoryFetchStatus.SUCCESSFUL.FOUND_IN_CACHE.INSTANCE;
        }
        boolean bl = false;
        Map errors = new LinkedHashMap();
        for (Repository repository : repositories) {
            RepositoryPolicy repositoryPolicy = repository.getReleases();
            Intrinsics.checkExpressionValueIsNotNull((Object)repositoryPolicy, (String)"repository.releases");
            if (!repositoryPolicy.isEnabled()) continue;
            String string = repository.getLayout();
            if (string == null) {
                throw (Throwable)new UnsupportedOperationException(repository.getLayout() + " layout not supported for " + repository.getId());
            }
            switch (string) {
                default: {
                    throw (Throwable)new UnsupportedOperationException(repository.getLayout() + " layout not supported for " + repository.getId());
                }
                case "default": 
            }
            FetchStatus.RepositoryFetchStatus result = this.fetchFileAndHashes(fileSpec, repository);
            Object object = result;
            if (object instanceof FetchStatus.RepositoryFetchStatus.FETCH_ERROR) {
                String string2 = repository.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"repository.id");
                errors.put(string2, result);
                continue;
            }
            if (object instanceof FetchStatus.RepositoryFetchStatus.NOT_FOUND || !(object instanceof FetchStatus.RepositoryFetchStatus.SUCCESSFUL)) continue;
        }
        if (!UtilsKt.getExists(fileSpec.getLocalFile())) {
            if (errors.isEmpty()) {
                fetchStatus = FetchStatus.RepositoryFetchStatus.NOT_FOUND.INSTANCE;
                return fetchStatus;
            }
            fetchStatus = new FetchStatus.ERROR(errors);
            return fetchStatus;
        }
        if (!fileSpec.validateHashes()) {
            fetchStatus = FetchStatus.INVALID_HASH.INSTANCE;
            return fetchStatus;
        }
        fetchStatus = FetchStatus.RepositoryFetchStatus.SUCCESSFUL.SUCCESSFULLY_FETCHED.INSTANCE;
        return fetchStatus;
    }

    private final FetchStatus.RepositoryFetchStatus fetchFileAndHashes(FileSpec fileSpec, Repository repository) {
        FetchStatus.RepositoryFetchStatus mainFetchResult = this.fetchFile(fileSpec, repository, fileSpec.getPath());
        Path path2 = HashingKt.getMd5File(fileSpec.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"fileSpec.path.md5File");
        this.fetchFile(fileSpec, repository, path2);
        Path path3 = HashingKt.getSha1File(fileSpec.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"fileSpec.path.sha1File");
        this.fetchFile(fileSpec, repository, path3);
        return mainFetchResult;
    }

    protected final void safeWrite(@NotNull Path localFile2, @NotNull byte[] body) {
        Intrinsics.checkParameterIsNotNull((Object)localFile2, (String)"localFile");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Files.createDirectories(localFile2.getParent(), new FileAttribute[0]);
        Path temp = Files.createTempFile(localFile2.getParent(), "temp-", ((Object)localFile2.getFileName()).toString(), new FileAttribute[0]);
        Files.write(temp, body, new OpenOption[0]);
        Files.move(temp, localFile2, StandardCopyOption.ATOMIC_MOVE);
    }

    @NotNull
    protected final Path getCacheDir() {
        return this.cacheDir;
    }

    public AbstractArtifactFetcher(@NotNull Path cacheDir) {
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this.cacheDir = cacheDir;
    }
}

