/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.tools.maven.resolution;

import com.squareup.tools.maven.resolution.Artifact;
import com.squareup.tools.maven.resolution.FileSpec;
import com.squareup.tools.maven.resolution.HashingKt;
import com.squareup.tools.maven.resolution.UtilsKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/squareup/tools/maven/resolution/FileSpec;", "", "artifact", "Lcom/squareup/tools/maven/resolution/Artifact;", "getArtifact", "()Lcom/squareup/tools/maven/resolution/Artifact;", "coordinate", "", "getCoordinate", "()Ljava/lang/String;", "localFile", "Ljava/nio/file/Path;", "getLocalFile", "()Ljava/nio/file/Path;", "path", "getPath", "validateHashes", "", "src_main_java_com_squareup_tools_maven_resolution-resolution"})
public interface FileSpec {
    @NotNull
    public Path getPath();

    @NotNull
    public Path getLocalFile();

    @NotNull
    public String getCoordinate();

    @NotNull
    public Artifact getArtifact();

    public boolean validateHashes();

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean validateHashes(FileSpec $this) {
            boolean bl = UtilsKt.getExists($this.getLocalFile());
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Attempted to validate hashes on an un-fetched pom file " + $this.getLocalFile() + '.';
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Path path2 = $this.getLocalFile();
            Path path3 = HashingKt.getSha1File($this.getLocalFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"localFile.sha1File");
            if (!HashingKt.validateHash(path2, "sha1", path3, (Function1<? super Path, String>)((Function1)validateHashes.2.INSTANCE))) return false;
            Path path4 = $this.getLocalFile();
            Path path5 = HashingKt.getMd5File($this.getLocalFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"localFile.md5File");
            if (!HashingKt.validateHash(path4, "md5", path5, (Function1<? super Path, String>)((Function1)validateHashes.3.INSTANCE))) return false;
            return true;
        }
    }
}

