/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.tools.maven.resolution;

import com.squareup.tools.maven.resolution.ArtifactFetcher;
import com.squareup.tools.maven.resolution.ArtifactFile;
import com.squareup.tools.maven.resolution.FetchStatus;
import com.squareup.tools.maven.resolution.FileSpec;
import com.squareup.tools.maven.resolution.HashingKt;
import com.squareup.tools.maven.resolution.PomFile;
import com.squareup.tools.maven.resolution.UtilsKt;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0003H$J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\rH\u0002J;\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0019\"\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lcom/squareup/tools/maven/resolution/AbstractArtifactFetcher;", "Lcom/squareup/tools/maven/resolution/ArtifactFetcher;", "cacheDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getCacheDir", "()Ljava/nio/file/Path;", "cachedFileOrFetch", "Lcom/squareup/tools/maven/resolution/FetchStatus;", "fileSpec", "Lcom/squareup/tools/maven/resolution/FileSpec;", "repositories", "", "Lorg/apache/maven/model/Repository;", "fetchArtifact", "artifactFile", "Lcom/squareup/tools/maven/resolution/ArtifactFile;", "fetchFile", "Lcom/squareup/tools/maven/resolution/FetchStatus$RepositoryFetchStatus;", "repository", "path", "fetchFileAndHashes", "fetchFiles", "", "files", "", "([Lcom/squareup/tools/maven/resolution/FileSpec;Ljava/util/List;)Ljava/util/Map;", "fetchPom", "pom", "Lcom/squareup/tools/maven/resolution/PomFile;", "safeWrite", "", "localFile", "body", "", "src_main_java_com_squareup_tools_maven_resolution-resolution"})
public abstract class AbstractArtifactFetcher
implements ArtifactFetcher {
    @NotNull
    private final Path cacheDir;

    @Override
    @NotNull
    public FetchStatus fetchPom(@NotNull PomFile pom, @NotNull List<? extends Repository> repositories) {
        Intrinsics.checkParameterIsNotNull((Object)pom, (String)"pom");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        return this.cachedFileOrFetch(pom, repositories);
    }

    @Override
    @NotNull
    public FetchStatus fetchArtifact(@NotNull ArtifactFile artifactFile, @NotNull List<? extends Repository> repositories) {
        Intrinsics.checkParameterIsNotNull((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        return this.fetchFile(artifactFile, repositories);
    }

    @Override
    @NotNull
    public FetchStatus fetchFile(@NotNull FileSpec artifactFile, @NotNull List<? extends Repository> repositories) {
        Intrinsics.checkParameterIsNotNull((Object)artifactFile, (String)"artifactFile");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        FileSpec[] fileSpecArray = new FileSpec[]{artifactFile};
        List<? extends Repository> list = repositories;
        return (FetchStatus)((Map.Entry)CollectionsKt.first((Iterable)this.fetchFiles(fileSpecArray, list).entrySet())).getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<FileSpec, FetchStatus> fetchFiles(@NotNull FileSpec[] files, @NotNull List<? extends Repository> repositories) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)files, (String)"files");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        FileSpec[] $this$map$iv = files;
        boolean $i$f$map = false;
        FileSpec[] fileSpecArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            FetchStatus fetchStatus;
            void v0;
            void file;
            void item$iv$iv;
            void var12_12 = item$iv$iv = var8_8[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_14 = file;
            try {
                v0 = var14_14;
                fetchStatus = this.cachedFileOrFetch((FileSpec)file, repositories);
            }
            catch (Exception exception) {
                Collection<String> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void e;
                Object object = repositories;
                StringBuilder stringBuilder = new StringBuilder().append("Error fetching ").append(file.getPath()).append(" from ");
                Integer n2 = null;
                Throwable throwable = (Throwable)e;
                String string = null;
                boolean $i$f$map2 = false;
                Throwable throwable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    Repository repository = (Repository)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = it.getId();
                    collection2.add(string2);
                }
                collection2 = (List)destination$iv$iv2;
                v0 = var14_14;
                object = stringBuilder.append(collection2).toString();
                Integer n3 = n2;
                throwable2 = throwable;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n4 = 5;
                Throwable throwable3 = throwable2;
                Integer n5 = n3;
                Object object2 = object;
                String string3 = string;
                fetchStatus = new FetchStatus.RepositoryFetchStatus.FETCH_ERROR(string3, object2, n5, throwable3, n4, defaultConstructorMarker);
            }
            Pair pair = TuplesKt.to((Object)v0, (Object)fetchStatus);
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    protected abstract FetchStatus.RepositoryFetchStatus fetchFile(@NotNull FileSpec var1, @NotNull Repository var2, @NotNull Path var3);

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private final FetchStatus cachedFileOrFetch(FileSpec fileSpec, List<? extends Repository> repositories) {
        FetchStatus fetchStatus;
        if (fileSpec.getArtifact().getSnapshot()) {
            return new FetchStatus.RepositoryFetchStatus.FETCH_ERROR(null, "Snapshot versions not supported (" + fileSpec.getArtifact().getCoordinate() + ')', null, null, 13, null);
        }
        if (UtilsKt.getExists(fileSpec.getLocalFile())) {
            UtilsKt.info((Function0<? extends Object>)((Function0)new Function0<String>(fileSpec){
                final /* synthetic */ FileSpec $fileSpec;

                @NotNull
                public final String invoke() {
                    return "Found cached file " + this.$fileSpec.getLocalFile();
                }
                {
                    this.$fileSpec = fileSpec;
                    super(0);
                }
            }));
            return FetchStatus.RepositoryFetchStatus.SUCCESSFUL.FOUND_IN_CACHE.INSTANCE;
        }
        boolean bl = false;
        Map errors = new LinkedHashMap();
        for (Repository repository : repositories) {
            RepositoryPolicy repositoryPolicy = repository.getReleases();
            Intrinsics.checkExpressionValueIsNotNull((Object)repositoryPolicy, (String)"repository.releases");
            if (!repositoryPolicy.isEnabled()) continue;
            String string = repository.getLayout();
            if (string == null) {
                throw (Throwable)new UnsupportedOperationException(repository.getLayout() + " layout not supported for " + repository.getId());
            }
            switch (string) {
                default: {
                    throw (Throwable)new UnsupportedOperationException(repository.getLayout() + " layout not supported for " + repository.getId());
                }
                case "default": 
            }
            FetchStatus.RepositoryFetchStatus result = this.fetchFileAndHashes(fileSpec, repository);
            Object object = result;
            if (object instanceof FetchStatus.RepositoryFetchStatus.FETCH_ERROR) {
                String string2 = repository.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"repository.id");
                errors.put(string2, result);
                continue;
            }
            if (object instanceof FetchStatus.RepositoryFetchStatus.NOT_FOUND || !(object instanceof FetchStatus.RepositoryFetchStatus.SUCCESSFUL)) continue;
        }
        if (!UtilsKt.getExists(fileSpec.getLocalFile())) {
            if (errors.isEmpty()) {
                fetchStatus = FetchStatus.RepositoryFetchStatus.NOT_FOUND.INSTANCE;
                return fetchStatus;
            }
            fetchStatus = new FetchStatus.ERROR(errors);
            return fetchStatus;
        }
        if (!fileSpec.validateHashes()) {
            fetchStatus = FetchStatus.INVALID_HASH.INSTANCE;
            return fetchStatus;
        }
        fetchStatus = FetchStatus.RepositoryFetchStatus.SUCCESSFUL.SUCCESSFULLY_FETCHED.INSTANCE;
        return fetchStatus;
    }

    private final FetchStatus.RepositoryFetchStatus fetchFileAndHashes(FileSpec fileSpec, Repository repository) {
        FetchStatus.RepositoryFetchStatus mainFetchResult = this.fetchFile(fileSpec, repository, fileSpec.getPath());
        Path path2 = HashingKt.getMd5File(fileSpec.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"fileSpec.path.md5File");
        this.fetchFile(fileSpec, repository, path2);
        Path path3 = HashingKt.getSha1File(fileSpec.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"fileSpec.path.sha1File");
        this.fetchFile(fileSpec, repository, path3);
        return mainFetchResult;
    }

    protected final void safeWrite(@NotNull Path localFile2, @NotNull byte[] body) {
        Intrinsics.checkParameterIsNotNull((Object)localFile2, (String)"localFile");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Files.createDirectories(localFile2.getParent(), new FileAttribute[0]);
        Path temp = Files.createTempFile(localFile2.getParent(), "temp-", ((Object)localFile2.getFileName()).toString(), new FileAttribute[0]);
        Files.write(temp, body, new OpenOption[0]);
        Files.move(temp, localFile2, StandardCopyOption.ATOMIC_MOVE);
    }

    @NotNull
    protected final Path getCacheDir() {
        return this.cacheDir;
    }

    public AbstractArtifactFetcher(@NotNull Path cacheDir) {
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        this.cacheDir = cacheDir;
    }
}

