/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.avalon;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;

public class JellyService
implements Configurable {
    private boolean m_configured = false;
    private Map m_scripts = new HashMap();

    public Map runNamedScript(String name, Map params) throws Exception {
        return this.runNamedScript(name, params, this.createXMLOutput());
    }

    public Map runNamedScript(String name, Map params, XMLOutput output) throws Exception {
        if (!this.m_scripts.containsKey(name)) {
            throw new JellyException("No script exists for script name [" + name + "]");
        }
        Script script = (Script)this.m_scripts.get(name);
        JellyContext context = this.createJellyContext();
        context.setVariables(params);
        script.run(context, output);
        return context.getVariables();
    }

    public Map runNamedScript(String name, Map params, OutputStream out) throws Exception {
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)out);
        Map answer = this.runNamedScript(name, params, xmlOutput);
        xmlOutput.flush();
        return answer;
    }

    public Map runScript(String url, Map params, XMLOutput output) throws Exception {
        URL actualUrl = null;
        try {
            actualUrl = new URL(url);
        }
        catch (MalformedURLException x) {
            throw new JellyException("Could not find script at URL [" + url + "]: " + x.getMessage(), (Throwable)x);
        }
        JellyContext context = this.createJellyContext();
        context.setVariables(params);
        context.runScript(url, output);
        return context.getVariables();
    }

    public Map runScript(String url, Map params, OutputStream out) throws Exception {
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)out);
        Map answer = this.runScript(url, params, xmlOutput);
        xmlOutput.flush();
        return answer;
    }

    public Map runScript(String url, Map params) throws Exception {
        return this.runScript(url, params, this.createXMLOutput());
    }

    public void configure(Configuration config) throws ConfigurationException {
        if (this.m_configured) {
            throw new ConfigurationException("configure may only be executed once");
        }
        if (!"jelly".equals(config.getName())) {
            throw new ConfigurationException("Expected <jelly> but got " + config.getName());
        }
        Configuration[] scripts = config.getChildren("scripts");
        int i = 0;
        while (i < scripts.length) {
            String name = config.getChild("name").getValue();
            try {
                String scriptName = config.getChild("url").getValue();
                URL url = null;
                File file = new File(scriptName);
                if (file.exists()) {
                    url = file.toURL();
                } else {
                    try {
                        url = new URL(scriptName);
                    }
                    catch (MalformedURLException mfue) {
                        url = this.getClass().getResource(scriptName);
                    }
                }
                if (url == null) {
                    throw new ConfigurationException("Could not find script [" + scriptName + "]");
                }
                Jelly jelly = new Jelly();
                jelly.setUrl(url);
                boolean validate = config.getChild("url").getAttributeAsBoolean("validate", false);
                jelly.setValidateXML(validate);
                Script script = jelly.compileScript();
                this.m_scripts.put(name, script);
            }
            catch (Throwable t) {
                throw new ConfigurationException("Could not load script [" + name + "]: " + t.getMessage());
            }
            ++i;
        }
    }

    protected JellyContext createJellyContext() {
        return new JellyContext();
    }

    protected XMLOutput createXMLOutput() {
        return new XMLOutput();
    }
}

