/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.ronaldoblanc.util;

import consulting.omnia.ronaldoblanc.util.ConnectionProperties;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SqlDeveloperXmlParser {
    public Map<String, ConnectionProperties> getConnections(String filename) throws ParserConfigurationException, SAXException, IOException {
        File file = new File(filename);
        Map<String, ConnectionProperties> connections = this.parseInputXml(file);
        return connections;
    }

    private byte[] stringToByte(String input) {
        int inputSize = input.length();
        char[] inputData = input.toCharArray();
        byte[] result = new byte[inputSize / 2];
        for (int i = 0; i < inputSize; i += 2) {
            String byteStr = new String(new char[]{inputData[i], inputData[i + 1]});
            result[i / 2] = (byte)Integer.parseInt(byteStr, 16);
        }
        return result;
    }

    private byte[] decryptPassword(String input) throws GeneralSecurityException {
        byte[] result = this.stringToByte(input);
        byte constant = result[0];
        if (constant != 5) {
            throw new IllegalArgumentException();
        }
        byte[] secretKey = new byte[8];
        System.arraycopy(result, 1, secretKey, 0, 8);
        byte[] encryptedPassword = new byte[result.length - 9];
        System.arraycopy(result, 9, encryptedPassword, 0, encryptedPassword.length);
        byte[] iv = new byte[8];
        for (int i = 0; i < iv.length; ++i) {
            iv[i] = 0;
        }
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        cipher.init(2, (Key)new SecretKeySpec(secretKey, "DES"), new IvParameterSpec(iv));
        return cipher.doFinal(encryptedPassword);
    }

    private Map<String, ConnectionProperties> parseInputXml(File xml) throws ParserConfigurationException, SAXException, IOException {
        final HashMap<String, ConnectionProperties> result = new HashMap<String, ConnectionProperties>();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(xml, new DefaultHandler(){
            final String STRING_REF_ADDR = "StringRefAddr";
            final String CONTENTS = "Contents";
            final String ADDR_TYPE = "addrType";
            final String CONNECTION_NAME = "ConnName";
            final String USER = "user";
            final String PASSWORD = "password";
            final String HOSTNAME = "hostname";
            final String PORT = "port";
            final String SID = "sid";
            final String CONNECTION_TYPE = "OracleConnectionType";
            final String DRIVER_CLASS = "driver";
            final String DRIVER_TYPE = "oraDriverType";
            final String URL = "customUrl";
            final String REFERENCE = "Reference";
            String actualConnection;
            boolean contents = false;
            boolean connectionName = false;
            boolean user = false;
            boolean password = false;
            boolean hostname = false;
            boolean port = false;
            boolean sid = false;
            boolean connectionType = false;
            boolean driverClass = false;
            boolean driverType = false;
            boolean url = false;

            @Override
            public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
                if (arg2.equalsIgnoreCase("Reference")) {
                    this.actualConnection = arg3.getValue("name");
                    result.put(this.actualConnection, new ConnectionProperties());
                }
                if (arg2.equalsIgnoreCase("Contents")) {
                    this.contents = true;
                }
                if (arg2.equalsIgnoreCase("StringRefAddr")) {
                    if (arg3.getValue("addrType").equalsIgnoreCase("ConnName")) {
                        this.connectionName = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("user")) {
                        this.user = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("password")) {
                        this.password = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("hostname")) {
                        this.hostname = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("port")) {
                        this.port = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("sid")) {
                        this.sid = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("OracleConnectionType")) {
                        this.connectionType = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("driver")) {
                        this.driverClass = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("oraDriverType")) {
                        this.driverType = true;
                    }
                    if (arg3.getValue("addrType").equalsIgnoreCase("customUrl")) {
                        this.url = true;
                    }
                }
            }

            @Override
            public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            }

            @Override
            public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
                if (this.contents) {
                    if (this.connectionName) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setConnectionName(new String(arg0, arg1, arg2));
                        this.connectionName = false;
                    }
                    if (this.user) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setUser(new String(arg0, arg1, arg2));
                        this.user = false;
                    }
                    if (this.password) {
                        try {
                            ((ConnectionProperties)result.get(this.actualConnection)).setPassword(new String(SqlDeveloperXmlParser.this.decryptPassword(new String(arg0, arg1, arg2))));
                        }
                        catch (GeneralSecurityException e) {
                            ((ConnectionProperties)result.get(this.actualConnection)).setPassword(new String(arg0, arg1, arg2));
                        }
                        this.password = false;
                    }
                    if (this.hostname) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setHostname(new String(arg0, arg1, arg2));
                        this.hostname = false;
                    }
                    if (this.port) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setPort(new String(arg0, arg1, arg2));
                        this.port = false;
                    }
                    if (this.sid) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setSid(new String(arg0, arg1, arg2));
                        this.sid = false;
                    }
                    if (this.connectionType) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setConnectionType(new String(arg0, arg1, arg2));
                        this.connectionType = false;
                    }
                    if (this.driverClass) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setDriverClass(new String(arg0, arg1, arg2));
                        this.driverClass = false;
                    }
                    if (this.driverType) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setDriverType(new String(arg0, arg1, arg2));
                        this.driverType = false;
                    }
                    if (this.url) {
                        ((ConnectionProperties)result.get(this.actualConnection)).setUrl(new String(arg0, arg1, arg2));
                        this.url = false;
                    }
                    this.contents = false;
                }
            }
        });
        return result;
    }
}

