package consulting.omnia.util.cast;

import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class NumberCastUtil extends AbstractCastUtil {
	
	protected static Number cast(final Object value) {
		return castAs(value, Number.class);
	}

	protected static BigDecimal numberToBigDecimal(final Number value) {
		final Class<? extends Number> type = value.getClass();
		if (Byte.class.isAssignableFrom(type)) {
			return new BigDecimal(value.byteValue());
		}
		if (Short.class.isAssignableFrom(type)) {
			return new BigDecimal(value.shortValue());
		}
		if (Integer.class.isAssignableFrom(type)) {
			return new BigDecimal(value.intValue());
		}
		if (Long.class.isAssignableFrom(type)) {
			return new BigDecimal(value.longValue());
		}
		if (Double.class.isAssignableFrom(type)) {
			return new BigDecimal(value.doubleValue());
		}
		if (Float.class.isAssignableFrom(type)) {
			return new BigDecimal(value.floatValue());
		}
		if (BigInteger.class.isAssignableFrom(type)) {
			return new BigDecimal(castAs(value, BigInteger.class));
		}
		if (BigDecimal.class.isAssignableFrom(type)) {
			return castAs(value, BigDecimal.class);
		}

		throw CastExceptionUtil.castException(type);
	}

	protected static <T> T bigDecimalToNumber(final BigDecimal number, final Class<T> type) {
		if (Byte.class.isAssignableFrom(type)) {
			return type.cast(number.byteValue());
		}
		if (Short.class.isAssignableFrom(type)) {
			return type.cast(number.shortValue());
		}
		if (Integer.class.isAssignableFrom(type)) {
			return type.cast(number.intValue());
		}
		if (Long.class.isAssignableFrom(type)) {
			return type.cast(number.longValue());
		}
		if (Double.class.isAssignableFrom(type)) {
			return type.cast(number.longValue());
		}
		if (Float.class.isAssignableFrom(type)) {
			return type.cast(number.floatValue());
		}
		if (BigInteger.class.isAssignableFrom(type)) {
			return type.cast(new BigInteger(number.toPlainString()));
		}
		if (BigDecimal.class.isAssignableFrom(type)) {
			return type.cast(number);
		}

		throw CastExceptionUtil.castException(type);
	}

	protected static <T> T stringToNumber(final String number, final Class<T> type) {
		final BigDecimal result = new BigDecimal(number);
		return bigDecimalToNumber(result, type);
	}

	protected static String numberToString(final Number number) {
		final BigDecimal result = numberToBigDecimal(number);
		return result.toPlainString();
	}

}
