/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.cast;

import consulting.omnia.util.cast.AbstractCastUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BooleanCastUtil
extends AbstractCastUtil {
    private static final Map<Locale, String> trueStrings = new HashMap<Locale, String>();
    private static final Map<Locale, Character> trueChars = new HashMap<Locale, Character>();
    private static final Map<Locale, String> falseStrings = new HashMap<Locale, String>();
    private static final Map<Locale, Character> falseChars = new HashMap<Locale, Character>();

    protected static void put(Locale locale, String trueValue, Character trueChar, String falseValue, Character falseChar) {
        trueChars.put(locale, trueChar);
        falseChars.put(locale, falseChar);
        trueStrings.put(locale, trueValue);
        falseStrings.put(locale, falseValue);
    }

    protected static Boolean cast(Object value) {
        return BooleanCastUtil.castAs(value, Boolean.class);
    }

    protected static Boolean stringToBoolean(String value) {
        return trueStrings.containsValue(value);
    }

    protected static Boolean charToBoolean(Character value) {
        return trueChars.containsValue(value);
    }

    protected static String booleanToString(Boolean value, Locale locale) {
        if (locale == null && !trueStrings.containsKey(locale)) {
            locale = Locale.ENGLISH;
        }
        return value != false ? trueStrings.get(locale) : falseStrings.get(locale);
    }

    protected static Character booleanToChar(Boolean value, Locale locale) {
        if (locale == null && !trueChars.containsKey(locale)) {
            locale = Locale.ENGLISH;
        }
        return value != false ? trueChars.get(locale) : falseChars.get(locale);
    }

    static {
        BooleanCastUtil.put(Locale.ENGLISH, "true", Character.valueOf('T'), "false", Character.valueOf('F'));
        BooleanCastUtil.put(Locale.forLanguageTag("es-*"), "verdadero", Character.valueOf('V'), "falso", Character.valueOf('F'));
        BooleanCastUtil.put(Locale.FRENCH, "vrai", Character.valueOf('V'), "faux", Character.valueOf('F'));
        BooleanCastUtil.put(Locale.forLanguageTag("pt-*"), "verdadeiro", Character.valueOf('V'), "falso", Character.valueOf('F'));
        BooleanCastUtil.put(Locale.ITALIAN, "vero", Character.valueOf('V'), "falso", Character.valueOf('F'));
        BooleanCastUtil.put(Locale.GERMAN, "richtig", Character.valueOf('R'), "falsch", Character.valueOf('F'));
    }
}

