/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.cast;

import consulting.omnia.util.cast.AbstractCastUtil;
import consulting.omnia.util.cast.BooleanCastUtil;
import consulting.omnia.util.cast.CastExceptionUtil;
import consulting.omnia.util.cast.DateCastUtil;
import consulting.omnia.util.cast.NumberCastUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;

public class CastUtil
extends AbstractCastUtil {
    public static <T> T getAs(Object value, Class<T> type) throws ParseException {
        if (value == null || type == null) {
            throw CastExceptionUtil.castException("Both value and type must be not null");
        }
        if (type.isAssignableFrom(value.getClass())) {
            return CastUtil.castAs(value, type);
        }
        if (value instanceof Number) {
            BigDecimal number = NumberCastUtil.numberToBigDecimal(CastUtil.castAs(value, Number.class));
            return CastUtil.numberToType(number, type);
        }
        if (value instanceof Date) {
            BigDecimal number = NumberCastUtil.numberToBigDecimal(CastUtil.castAs(value, Date.class).getTime());
            return CastUtil.numberToType(number, type);
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = CastUtil.castAs(value, Boolean.class);
            return booleanValue != false ? CastUtil.numberToType(BigDecimal.ONE, type) : CastUtil.numberToType(BigDecimal.ZERO, type);
        }
        if (value instanceof String) {
            try {
                BigDecimal number = new BigDecimal(CastUtil.castAs(value, String.class));
                return CastUtil.numberToType(number, type);
            }
            catch (NumberFormatException nfe) {
                if (Boolean.class.isAssignableFrom(type)) {
                    return type.cast(BooleanCastUtil.stringToBoolean(CastUtil.castAs(value, String.class)));
                }
                if (Date.class.isAssignableFrom(type)) {
                    return type.cast(DateCastUtil.stringToDate(CastUtil.castAs(value, String.class)));
                }
                throw CastExceptionUtil.castException(value, type);
            }
        }
        if (value instanceof Character) {
            BigDecimal number = new BigDecimal(CastUtil.castAs(value, Character.class).toString());
            return CastUtil.numberToType(number, type);
        }
        throw CastExceptionUtil.castException(value, type);
    }

    public static String numberAsString(Number number) {
        return NumberCastUtil.numberToString(number);
    }

    private static <R> R numberToType(BigDecimal number, Class<R> type) {
        if (Number.class.isAssignableFrom(type)) {
            return NumberCastUtil.bigDecimalToNumber(number, type);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return type.cast(BigDecimal.ONE.compareTo(number) == 0);
        }
        if (Date.class.isAssignableFrom(type)) {
            return type.cast(new Date(NumberCastUtil.bigDecimalToNumber(number, Long.class)));
        }
        if (String.class.isAssignableFrom(type)) {
            return type.cast(number.toPlainString());
        }
        throw CastExceptionUtil.castException(number, type);
    }
}

