/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.cast;

import consulting.omnia.util.cast.AbstractCastUtil;
import consulting.omnia.util.cast.CastExceptionUtil;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class NumberCastUtil
extends AbstractCastUtil {
    protected static Number cast(Object value) {
        return NumberCastUtil.castAs(value, Number.class);
    }

    protected static BigDecimal numberToBigDecimal(Number value) {
        Class<?> type = value.getClass();
        if (Byte.class.isAssignableFrom(type)) {
            return new BigDecimal(value.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return new BigDecimal(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return new BigDecimal(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return new BigDecimal(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return new BigDecimal(value.doubleValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return new BigDecimal(value.floatValue());
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return new BigDecimal(NumberCastUtil.castAs(value, BigInteger.class));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return NumberCastUtil.castAs(value, BigDecimal.class);
        }
        throw CastExceptionUtil.castException(type);
    }

    protected static <T> T bigDecimalToNumber(BigDecimal number, Class<T> type) {
        if (Byte.class.isAssignableFrom(type)) {
            return type.cast(number.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return type.cast(number.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return type.cast(number.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return type.cast(number.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return type.cast(number.longValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return type.cast(Float.valueOf(number.floatValue()));
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return type.cast(new BigInteger(number.toPlainString()));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return type.cast(number);
        }
        throw CastExceptionUtil.castException(type);
    }

    protected static <T> T stringToNumber(String number, Class<T> type) {
        BigDecimal result = new BigDecimal(number);
        return NumberCastUtil.bigDecimalToNumber(result, type);
    }

    protected static String numberToString(Number number) {
        BigDecimal result = NumberCastUtil.numberToBigDecimal(number);
        return result.toPlainString();
    }
}

