/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.cast;

import consulting.omnia.util.cast.CastUtilExceptionHandler;
import consulting.omnia.util.cast.collections.ListCastUtil;
import consulting.omnia.util.cast.number.NumberCast;
import consulting.omnia.util.cast.parser.BooleanCastParser;
import consulting.omnia.util.cast.parser.DateCastParser;
import consulting.omnia.util.cast.visitor.AbstractCastMainDataVisitor;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class CastUtil {
    private static final CastMainDataVisitor CAST_VISITOR = new CastMainDataVisitor();

    public static <R> R castAs(Object value, Class<R> type) {
        if (value == null || type == null) {
            throw CastUtilExceptionHandler.castException("Both value and type must be not null");
        }
        return CAST_VISITOR.asType(value, type);
    }

    public static <R> List<R> getAsList(List<?> value) {
        return ListCastUtil.cast(value);
    }

    private static class CastMainDataVisitor
    extends AbstractCastMainDataVisitor {
        private Object result;
        private Class<?> type;

        private CastMainDataVisitor() {
        }

        public <R> R asType(Object value, Class<R> type) {
            if (type.isAssignableFrom(value.getClass())) {
                return CastMainDataVisitor.castAs(value, type);
            }
            this.type = type;
            this.accept(value);
            return CastMainDataVisitor.castAs(this.result, type);
        }

        @Override
        public void visit(Character value) {
            this.result = value;
            this.visit(this.type);
        }

        @Override
        public void visit(String value) {
            this.result = value;
            this.visit(this.type);
        }

        @Override
        public void visit(Date value) {
            BigDecimal number = NumberCast.asNumber(value, BigDecimal.class);
            this.result = NumberCast.asType(number, this.type);
        }

        @Override
        public void visit(Boolean value) {
            Boolean booleanValue = CastMainDataVisitor.castAs(value, Boolean.class);
            this.result = booleanValue != false ? NumberCast.asType(BigDecimal.ONE, this.type) : NumberCast.asType(BigDecimal.ZERO, this.type);
        }

        @Override
        public void visit(Number value) {
            this.result = NumberCast.asType(CastMainDataVisitor.castAs(value, Number.class), this.type);
        }

        @Override
        public void visit(Class<?> value) {
            if (Boolean.class.isAssignableFrom(this.type)) {
                if (this.result instanceof String) {
                    this.result = this.type.cast(BooleanCastParser.stringToBoolean(CastMainDataVisitor.castAs(this.result, String.class)));
                    return;
                }
                if (this.result instanceof Character) {
                    this.result = this.type.cast(BooleanCastParser.charToBoolean(CastMainDataVisitor.castAs(this.result, Character.class)));
                    return;
                }
            }
            if (Date.class.isAssignableFrom(this.type)) {
                try {
                    this.result = this.type.cast(DateCastParser.stringToDate(CastMainDataVisitor.castAs(this.result, String.class)));
                    return;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.tryAsNumber();
        }

        private void tryAsNumber() {
            try {
                BigDecimal number = NumberCast.asNumber(this.result, BigDecimal.class);
                this.result = NumberCast.asType(number, this.type);
            }
            catch (NumberFormatException nfe) {
                throw CastUtilExceptionHandler.castException(this.result, this.type);
            }
        }
    }
}

