/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.cast.number;

import consulting.omnia.util.cast.AbstractCast;
import consulting.omnia.util.cast.CastUtilExceptionHandler;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class NumberBigDecimalCast
extends AbstractCast {
    public static BigDecimal numberToBigDecimal(Number value) {
        Class<?> type = value.getClass();
        if (Byte.class.isAssignableFrom(type)) {
            return new BigDecimal(value.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return new BigDecimal(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return new BigDecimal(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return new BigDecimal(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return new BigDecimal(value.doubleValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return new BigDecimal(value.floatValue());
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return new BigDecimal(NumberBigDecimalCast.castAs(value, BigInteger.class));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return NumberBigDecimalCast.castAs(value, BigDecimal.class);
        }
        throw CastUtilExceptionHandler.castException(type);
    }

    public static <T> T bigDecimalToNumber(BigDecimal number, Class<T> type) {
        if (Byte.class.isAssignableFrom(type)) {
            return type.cast(number.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return type.cast(number.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return type.cast(number.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return type.cast(number.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return type.cast(number.longValue());
        }
        if (Float.class.isAssignableFrom(type)) {
            return type.cast(Float.valueOf(number.floatValue()));
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return type.cast(new BigInteger(number.toPlainString()));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return type.cast(number);
        }
        throw CastUtilExceptionHandler.castException(type);
    }
}

