/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.cast.number;

import consulting.omnia.util.cast.number.NumberBigDecimalCast;
import consulting.omnia.util.cast.visitor.AbstractCastMainDataVisitor;
import java.math.BigDecimal;
import java.util.Date;

public class NumberCast {
    private static final NumberCastMainDataVisitor NUMBER_CAST_VISITOR = new NumberCastMainDataVisitor();

    public static <R extends Number> R asNumber(Object value, Class<R> type) {
        return (R)((Number)NUMBER_CAST_VISITOR.asNumber(value, type));
    }

    public static <R> R asType(Number value, Class<R> type) {
        return NUMBER_CAST_VISITOR.asType(value, type);
    }

    private static class NumberCastMainDataVisitor
    extends AbstractCastMainDataVisitor {
        private BigDecimal number;
        private Object result;

        private NumberCastMainDataVisitor() {
        }

        public <R> R asNumber(Object value, Class<R> type) {
            this.accept(value);
            return NumberBigDecimalCast.bigDecimalToNumber(this.number, type);
        }

        public <R> R asType(Number value, Class<R> type) {
            this.result = value;
            this.accept(type);
            return NumberCastMainDataVisitor.castAs(this.result, type);
        }

        @Override
        public void visit(Character value) {
            this.number = new BigDecimal(NumberCastMainDataVisitor.castAs(value, Character.class).toString());
        }

        @Override
        public void visit(String value) {
            this.number = new BigDecimal(NumberCastMainDataVisitor.castAs(value, String.class));
        }

        @Override
        public void visit(Date value) {
            this.number = NumberBigDecimalCast.numberToBigDecimal(NumberCastMainDataVisitor.castAs(value, Date.class).getTime());
        }

        @Override
        public void visit(Boolean value) {
            this.number = NumberCastMainDataVisitor.castAs(value, Boolean.class) == Boolean.TRUE ? BigDecimal.ONE : BigDecimal.ZERO;
        }

        @Override
        public void visit(Number value) {
            this.number = NumberBigDecimalCast.numberToBigDecimal(NumberCastMainDataVisitor.castAs(value, Number.class));
        }

        @Override
        public void visit(Class<?> type) {
            if (String.class.isAssignableFrom(type)) {
                this.result = String.valueOf(this.result);
            }
            if (Date.class.isAssignableFrom(type)) {
                this.result = new Date(NumberCastMainDataVisitor.castAs(this.result, Number.class).longValue());
            }
            if (Boolean.class.isAssignableFrom(type)) {
                this.result = NumberCastMainDataVisitor.castAs(this.result, Number.class).byteValue() == 1;
            }
            if (Number.class.isAssignableFrom(type)) {
                this.result = NumberBigDecimalCast.numberToBigDecimal(NumberCastMainDataVisitor.castAs(this.result, Number.class));
                this.result = this.asNumber(this.result, type);
            }
        }
    }
}

