/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.cast.parser;

import consulting.omnia.util.cast.AbstractCast;
import consulting.omnia.util.cast.parser.config.DateCastParserConfig;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateCastParser
extends AbstractCast {
    public static Date stringToDate(String value) throws ParseException {
        Date result;
        Throwable e = null;
        boolean auto = false;
        switch (DateCastParserConfig.getDateCastType()) {
            case AUTO: {
                auto = true;
                for (String format : DateCastParserConfig.getYearFirstFormats()) {
                    try {
                        Date result2 = DateCastParser.tryToParseIt(value, format);
                        return result2;
                    }
                    catch (Throwable t) {
                        e = t;
                    }
                }
            }
            case MONTH_FIRST: {
                for (String format : DateCastParserConfig.getMonthFirstFormats()) {
                    try {
                        result = DateCastParser.tryToParseIt(value, format);
                        return result;
                    }
                    catch (Throwable t) {
                        e = t;
                    }
                }
                if (!auto) break;
            }
            case DAY_FIRST: {
                for (String format : DateCastParserConfig.getDayFirstFormats()) {
                    try {
                        result = DateCastParser.tryToParseIt(value, format);
                        return result;
                    }
                    catch (Throwable t) {
                        e = t;
                    }
                }
                break;
            }
        }
        for (String format : DateCastParserConfig.getTimeOnlyFormats()) {
            try {
                result = DateCastParser.tryToParseIt(value, format);
                return result;
            }
            catch (Throwable t) {
            }
        }
        return (Date)DateCastParser.handleException(e);
    }

    private static Date tryToParseIt(String value, String formatTemplate) throws ParseException {
        Exception t = null;
        for (String dateSeparator : DateCastParserConfig.getDateSeparators()) {
            for (String dateTimeSeparator : DateCastParserConfig.getDateTimeSeparators()) {
                for (String timeSeparator : DateCastParserConfig.getTimeSeparators()) {
                    for (String miliSeparator : DateCastParserConfig.getMiliSeparators()) {
                        try {
                            String format = String.format(formatTemplate, dateSeparator, dateTimeSeparator, timeSeparator, miliSeparator);
                            SimpleDateFormat sdf = new SimpleDateFormat(format);
                            Date result = sdf.parse(value);
                            DateCastParser.checkResult(result, value, format);
                            return result;
                        }
                        catch (Exception e) {
                            t = e;
                        }
                    }
                }
            }
        }
        return (Date)DateCastParser.handleException(t);
    }

    private static void checkResult(Date result, String value, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String aux = sdf.format(result);
        if (!value.equalsIgnoreCase(aux)) {
            throw new IllegalStateException();
        }
    }

    private static <R> R handleException(Throwable t) throws ParseException {
        if (t == null) {
            return null;
        }
        if (t instanceof ParseException) {
            throw DateCastParser.castAs(t, ParseException.class);
        }
        throw new RuntimeException(t);
    }
}

