/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.cast.parser.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BooleanCastParserConfig {
    private static final Map<Locale, String> trueStrings = new HashMap<Locale, String>();
    private static final Map<Locale, Character> trueChars = new HashMap<Locale, Character>();
    private static final Map<Locale, String> falseStrings = new HashMap<Locale, String>();
    private static final Map<Locale, Character> falseChars = new HashMap<Locale, Character>();

    public static void put(Locale locale, String trueValue, Character trueChar, String falseValue, Character falseChar) {
        trueChars.put(locale, trueChar);
        falseChars.put(locale, falseChar);
        trueStrings.put(locale, trueValue);
        falseStrings.put(locale, falseValue);
    }

    public static Map<Locale, String> getTrueStrings() {
        return trueStrings;
    }

    public static Map<Locale, Character> getTrueChars() {
        return trueChars;
    }

    public static Map<Locale, String> getFalseStrings() {
        return falseStrings;
    }

    public static Map<Locale, Character> getFalseChars() {
        return falseChars;
    }

    static {
        BooleanCastParserConfig.put(Locale.ENGLISH, "true", Character.valueOf('T'), "false", Character.valueOf('F'));
        BooleanCastParserConfig.put(new Locale("es"), "verdadero", Character.valueOf('V'), "falso", Character.valueOf('F'));
        BooleanCastParserConfig.put(Locale.FRENCH, "vrai", Character.valueOf('V'), "faux", Character.valueOf('F'));
        BooleanCastParserConfig.put(new Locale("pt"), "verdadeiro", Character.valueOf('V'), "falso", Character.valueOf('F'));
        BooleanCastParserConfig.put(Locale.ITALIAN, "vero", Character.valueOf('V'), "falso", Character.valueOf('F'));
        BooleanCastParserConfig.put(Locale.GERMAN, "richtig", Character.valueOf('R'), "falsch", Character.valueOf('F'));
    }
}

