/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.classloader;

import consulting.omnia.util.cast.CastUtil;
import consulting.omnia.util.classloader.elements.Directory;
import consulting.omnia.util.classloader.visitor.DirectoryTypeScanner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class ClassLoaderScanner {
    private final List<Class<?>> foundTypes = new LinkedList();

    public <R> List<Class<R>> scan(Class<R> type) throws IOException, ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = contextClassLoader.getResources("");
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String path = resource.getPath();
            if (path == null || path.isEmpty()) continue;
            Directory rootDir = new Directory(new File(path));
            DirectoryTypeScanner scanner = new DirectoryTypeScanner(type);
            this.foundTypes.addAll(scanner.scan(rootDir));
        }
        return CastUtil.getAsList(this.foundTypes);
    }
}

