package consulting.omnia.util.converter;

import consulting.omnia.util.cast.CastUtil;

public class ConverterUtil {

	public static <T, R> R convertData(final Object value, final Class<T> convertFromType, final Class<R> convertToType, final Converter<T, R> converter) {
		final Object result = converter.convert(CastUtil.castAs(value, convertFromType));
		return convertToType.cast(result);
	}

	public static <T, R> T restoreData(final Object value, final Class<R> restoreFromType, final Class<T> restoreToType, final Converter<T, R> converter) {
		final Object result = converter.restore(CastUtil.castAs(value, restoreFromType));
		return restoreToType.cast(result);
	}

}