/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.converter;

import consulting.omnia.util.cast.CastUtil;
import consulting.omnia.util.classloader.ClassLoaderScanner;
import consulting.omnia.util.converter.Converter;
import consulting.omnia.util.reflection.ReflectionUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConverterUtil {
    private static final int FROM = 0;
    private static final int TO = 1;
    private static final Map<Class, Map<Class, Converter>> converters = new HashMap<Class, Map<Class, Converter>>();

    public static <T, R> R convertData(T value, Class<R> convertToType) {
        try {
            Converter<?, R> converter = ConverterUtil.findConverter(value.getClass(), convertToType);
            R result = converter.format(value);
            return convertToType.cast(result);
        }
        catch (IllegalStateException e) {
            try {
                return (R)CastUtil.castAs(value, convertToType);
            }
            catch (RuntimeException re) {
                throw new IllegalStateException("Error converting value: [" + value + "] to type: [" + convertToType.getCanonicalName() + "]", e);
            }
        }
    }

    public static <T, R> T restoreData(R value, Class<T> restoreToType) throws ParseException {
        try {
            Converter<T, ?> converter = ConverterUtil.findConverter(restoreToType, value.getClass());
            T result = converter.parse(value);
            return restoreToType.cast(result);
        }
        catch (IllegalStateException e) {
            try {
                return (T)CastUtil.castAs(value, restoreToType);
            }
            catch (RuntimeException re) {
                throw new IllegalStateException("Error converting value: [" + value + "] to type: [" + restoreToType.getCanonicalName() + "]", e);
            }
        }
    }

    private static Class<?>[] listTypes(Class<Converter> klass) {
        Class[] result = ReflectionUtil.listGenericTypes(klass);
        return result;
    }

    private static <T, R> Converter<T, R> findConverter(Class<T> fromType, Class<R> toType) {
        Converter result;
        Map<Class, Converter> map;
        if (converters.containsKey(fromType) && (map = converters.get(fromType)) != null && map.containsKey(toType) && (result = map.get(toType)) != null) {
            return result;
        }
        throw new IllegalStateException("Unable to find a suitable converter in classpath. Types:[from: " + fromType + ", to: " + toType);
    }

    static {
        try {
            ClassLoaderScanner scanner = new ClassLoaderScanner();
            List klasses = scanner.scan(Converter.class);
            for (Class klass : klasses) {
                Class<?>[] types = ConverterUtil.listTypes(klass);
                if (!converters.containsKey(types[0])) {
                    converters.put(types[0], new HashMap());
                }
                converters.get(types[0]).put(types[1], (Converter)klass.newInstance());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

