/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.io.file.core;

import consulting.omnia.util.io.file.api.DataWritter;
import consulting.omnia.util.io.file.api.NoSuchFileException;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class DefaultFileDataWritter
implements DataWritter {
    private static final Logger LOGGER = Logger.getLogger(DefaultFileDataWritter.class.getCanonicalName());
    private DataOutput dataOutput;

    public DefaultFileDataWritter(String filename) throws NoSuchFileException {
        LOGGER.finer("File [" + filename + "] is ready.");
        try {
            this.dataOutput = new DataOutputStream(new FileOutputStream(new File(filename)));
        }
        catch (FileNotFoundException e) {
            String[] filenameParts = filename.split("/");
            String dirName = "";
            for (int index = 0; index < filenameParts.length - 1; ++index) {
                dirName = dirName.concat(filenameParts[index]).concat("/");
            }
            File dir = new File(dirName);
            boolean exists = dir.exists();
            boolean created = false;
            if (!exists) {
                created = dir.mkdirs();
            }
            if (!exists && !created) {
                throw new NoSuchFileException(filename, e);
            }
            try {
                this.dataOutput = new DataOutputStream(new FileOutputStream(new File(filename)));
            }
            catch (FileNotFoundException e1) {
                throw new NoSuchFileException(filename, e);
            }
        }
    }

    @Override
    public void write(String data) throws IOException {
        LOGGER.finest("Writing data: [" + data + "]");
        this.dataOutput.writeBytes(data);
    }
}

