/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.io.file;

import consulting.omnia.util.cast.CastUtil;
import consulting.omnia.util.converter.Converter;
import consulting.omnia.util.converter.annotation.DataConverter;
import consulting.omnia.util.format.StringUtil;
import consulting.omnia.util.io.file.LineFeedType;
import consulting.omnia.util.io.file.annotation.FixedSizeField;
import consulting.omnia.util.io.file.record.RecordType;
import consulting.omnia.util.reflection.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class FlatFileDataReader {
    private static final FlatFileDataReader INSTANCE = new FlatFileDataReader();
    private InputStream is;
    private Integer fileSizeInBytes;
    private Integer totalRecords;
    private Integer remainder;
    private LineFeedType lineFeedType;

    private FlatFileDataReader() {
    }

    public static FlatFileDataReader getInstance() {
        return INSTANCE;
    }

    public void prepare(InputStream is, Integer recordSize) throws IOException {
        this.is = is;
        this.fileSizeInBytes = is.available();
        this.totalRecords = this.fileSizeInBytes / recordSize;
        this.remainder = this.fileSizeInBytes % recordSize;
        this.lineFeedType = this.inferLineFeedType(this.totalRecords, this.remainder);
    }

    public <T> List<T> readRecords(Class<T> clazz, Comparator<Field> comparator, RecordType recordType) throws Exception {
        switch (recordType) {
            case HEADER: 
            case TRAILLER: {
                T record = this.readRecord(this.is, clazz, comparator);
                this.lineFeed(this.is, this.lineFeedType);
                return Collections.singletonList(record);
            }
            case DETAIL_ONLY: {
                return this.readDetailRecords(clazz, comparator, this.totalRecords);
            }
            case DETAIL_HEADER: 
            case DETAIL_TRAILLER: {
                return this.readDetailRecords(clazz, comparator, this.totalRecords - 1);
            }
            case DETAIL: {
                return this.readDetailRecords(clazz, comparator, this.totalRecords - 2);
            }
        }
        throw new UnsupportedOperationException("Unknow record type: [" + (Object)((Object)recordType) + "]");
    }

    private <T> List<T> readDetailRecords(Class<T> clazz, Comparator<Field> comparator, Integer recordsToRead) throws Exception {
        LinkedList<T> result = new LinkedList<T>();
        for (int recordIndex = 0; recordIndex < recordsToRead; ++recordIndex) {
            T record = this.readRecord(this.is, clazz, comparator);
            this.lineFeed(this.is, this.lineFeedType);
            result.add(record);
        }
        return result;
    }

    private LineFeedType inferLineFeedType(Integer totalRecords, Integer remainder) {
        int _remainder = remainder % totalRecords;
        int size = 0;
        size = _remainder == 0 ? remainder / totalRecords : remainder / (totalRecords - 1);
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return LineFeedType.UNIX_LIKE;
            }
            case 2: {
                return LineFeedType.WINDOWS_LIKE;
            }
        }
        throw new IllegalArgumentException("I don't know any line feed with a such size: [" + size + "]");
    }

    private void lineFeed(InputStream is, LineFeedType lineFeedType) throws IOException {
        if (lineFeedType == null) {
            return;
        }
        switch (lineFeedType) {
            case UNIX_LIKE: {
                this.readLineFeedByte(is);
                break;
            }
            case WINDOWS_LIKE: {
                this.readLineFeedByte(is);
                this.readLineFeedByte(is);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown line feed type: [" + (Object)((Object)lineFeedType) + "]");
            }
        }
    }

    private void readLineFeedByte(InputStream is) throws IOException {
        is.read();
    }

    private <T> T readRecord(InputStream is, Class<T> clazz, Comparator<Field> comparator) throws Exception {
        T record = clazz.newInstance();
        for (Field field : ReflectionUtil.listAllFields(record, comparator)) {
            if (!field.isAnnotationPresent(FixedSizeField.class)) continue;
            FixedSizeField annotation = field.getAnnotation(FixedSizeField.class);
            Object value = this.read(is, annotation.pos(), annotation.length(), field.getType());
            if (field.isAnnotationPresent(DataConverter.class)) {
                DataConverter dataConverter = field.getAnnotation(DataConverter.class);
                Class converterClass = dataConverter.converter();
                Object converter = converterClass.newInstance();
                value = ((Converter)converter).parse(value);
            }
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            field.set(record, value);
        }
        return record;
    }

    private Object read(InputStream is, int pos, int size, Class<?> clazz) throws IOException, ParseException {
        byte[] buffer = new byte[size];
        is.read(buffer, 0, size);
        String value = new String(buffer).trim();
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        return CastUtil.castAs((Object)value, clazz);
    }
}

