/*
 * Decompiled with CFR 0.152.
 */
package cool.arch.patterns.observer;

import cool.arch.patterns.observer.NotifyableObservable;
import cool.arch.patterns.observer.Observer;
import cool.arch.patterns.observer.Segment;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

class NotifyableObservableImpl<T>
implements NotifyableObservable<T> {
    private Class<T> publishedType;
    private AtomicReference<Segment<Observer<T>>> observers = new AtomicReference();
    private Object lock = new Object();

    NotifyableObservableImpl(Class<T> publishedType) {
        this.publishedType = Objects.requireNonNull(publishedType, "publishedType shall not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(Observer<T> observer) {
        Objects.requireNonNull(observer, "observer shall not be null");
        Object object = this.lock;
        synchronized (object) {
            List<Observer<T>> collected = this.collectObservers();
            collected.add(observer);
            Segment<Observer<T>> segments = this.toSegments(collected);
            this.observers.set(segments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(Observer<T> observer) {
        Objects.requireNonNull(observer, "observer shall not be null");
        Object object = this.lock;
        synchronized (object) {
            List<Observer<T>> collected = this.collectObservers();
            collected.remove(observer);
            Segment<Observer<T>> segments = this.toSegments(collected);
            this.observers.set(segments);
        }
    }

    @Override
    public void clear() {
        this.observers.set(null);
    }

    @Override
    public Class<T> getPublishedType() {
        return this.publishedType;
    }

    @Override
    public void notifyObservers(T published) {
        Objects.requireNonNull(published, "published shall not be null");
        for (Segment<Observer<T>> head = this.observers.get(); head != null; head = head.getTail()) {
            Observer<T> observer = head.getItem();
            observer.onPublished(published);
        }
    }

    private List<Observer<T>> collectObservers() {
        LinkedList<Observer<T>> collected = new LinkedList<Observer<T>>();
        for (Segment<Observer<T>> head = this.observers.get(); head != null; head = head.getTail()) {
            Observer<T> observer = head.getItem();
            collected.add(observer);
        }
        return collected;
    }

    private Segment<Observer<T>> toSegments(Collection<Observer<T>> items) {
        Segment<Observer<T>> head = null;
        for (Observer<T> observer : items) {
            head = new Segment<Observer<T>>(observer, head);
        }
        return head;
    }
}

