/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.autoconfigure;

import java.util.List;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="openai")
public class OpenAiProperties {
    private String key;
    private String organization;
    private OpenAiTextCompletionProperties textCompletion = new OpenAiTextCompletionProperties();
    private OpenAiChatCompletionProperties chatCompletion = new OpenAiChatCompletionProperties();
    private OpenAiModerationProperties moderation = new OpenAiModerationProperties();
    private OpenAiImageGenerationProperties imageGeneration = new OpenAiImageGenerationProperties();
    private OpenAiImageEditProperties imageEdit = new OpenAiImageEditProperties();
    private OpenAiImageVariationProperties imageVariation = new OpenAiImageVariationProperties();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public OpenAiTextCompletionProperties getTextCompletion() {
        return this.textCompletion;
    }

    public void setTextCompletion(OpenAiTextCompletionProperties textCompletion) {
        this.textCompletion = textCompletion;
    }

    public OpenAiChatCompletionProperties getChatCompletion() {
        return this.chatCompletion;
    }

    public void setChatCompletion(OpenAiChatCompletionProperties chatCompletion) {
        this.chatCompletion = chatCompletion;
    }

    public OpenAiModerationProperties getModeration() {
        return this.moderation;
    }

    public void setModeration(OpenAiModerationProperties moderation) {
        this.moderation = moderation;
    }

    public OpenAiImageGenerationProperties getImageGeneration() {
        return this.imageGeneration;
    }

    public void setImageGeneration(OpenAiImageGenerationProperties imageGeneration) {
        this.imageGeneration = imageGeneration;
    }

    public OpenAiImageEditProperties getImageEdit() {
        return this.imageEdit;
    }

    public void setImageEdit(OpenAiImageEditProperties imageEdit) {
        this.imageEdit = imageEdit;
    }

    public OpenAiImageVariationProperties getImageVariation() {
        return this.imageVariation;
    }

    public void setImageVariation(OpenAiImageVariationProperties imageVariation) {
        this.imageVariation = imageVariation;
    }

    public static class OpenAiTextCompletionProperties {
        private String model = "text-davinci-003";
        private String suffix;
        @DecimalMin(value="0")
        @DecimalMax(value="2")
        private @DecimalMin(value="0") @DecimalMax(value="2") Double temperature;
        private Double topP;
        private Integer n;
        private Integer maxTokens;
        private boolean stream;
        private boolean echo;
        @Min(value=0L)
        @Max(value=5L)
        private @Min(value=0L) @Max(value=5L) Integer logprobs;
        private List<String> stop;
        @DecimalMin(value="-2.0")
        @DecimalMax(value="2.0")
        private @DecimalMin(value="-2.0") @DecimalMax(value="2.0") Double presencePenalty;
        @DecimalMin(value="-2.0")
        @DecimalMax(value="2.0")
        private @DecimalMin(value="-2.0") @DecimalMax(value="2.0") Double frequencyPenalty;
        @Min(value=0L)
        @Max(value=20L)
        private @Min(value=0L) @Max(value=20L) Integer bestOf;
        private Map<Integer, Double> logitBias;
        private String user;

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public Double getTemperature() {
            return this.temperature;
        }

        public void setTemperature(Double temperature) {
            this.temperature = temperature;
        }

        public Double getTopP() {
            return this.topP;
        }

        public void setTopP(Double topP) {
            this.topP = topP;
        }

        public Integer getN() {
            return this.n;
        }

        public void setN(Integer n) {
            this.n = n;
        }

        public Integer getMaxTokens() {
            return this.maxTokens;
        }

        public void setMaxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
        }

        public Integer getLogprobs() {
            return this.logprobs;
        }

        public void setLogprobs(Integer logprobs) {
            this.logprobs = logprobs;
        }

        public boolean isStream() {
            return this.stream;
        }

        public void setStream(boolean stream) {
            this.stream = stream;
        }

        public boolean isEcho() {
            return this.echo;
        }

        public void setEcho(boolean echo) {
            this.echo = echo;
        }

        public List<String> getStop() {
            return this.stop;
        }

        public void setStop(List<String> stop) {
            this.stop = stop;
        }

        public Double getPresencePenalty() {
            return this.presencePenalty;
        }

        public void setPresencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
        }

        public Double getFrequencyPenalty() {
            return this.frequencyPenalty;
        }

        public void setFrequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
        }

        public Integer getBestOf() {
            return this.bestOf;
        }

        public void setBestOf(Integer bestOf) {
            this.bestOf = bestOf;
        }

        public Map<Integer, Double> getLogitBias() {
            return this.logitBias;
        }

        public void setLogitBias(Map<Integer, Double> logitBias) {
            this.logitBias = logitBias;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }
    }

    public static class OpenAiChatCompletionProperties {
        private String model = "gpt-3.5-turbo";
        @DecimalMin(value="0")
        @DecimalMax(value="2")
        private @DecimalMin(value="0") @DecimalMax(value="2") Double temperature;
        private Double topP;
        private Integer n;
        private boolean stream;
        private List<String> stop;
        private Integer maxPromptToken = 3000;
        private Integer maxCompletionToken;
        @DecimalMin(value="-2.0")
        @DecimalMax(value="2.0")
        private @DecimalMin(value="-2.0") @DecimalMax(value="2.0") Double presencePenalty;
        @DecimalMin(value="-2.0")
        @DecimalMax(value="2.0")
        private @DecimalMin(value="-2.0") @DecimalMax(value="2.0") Double frequencyPenalty;
        private Map<Integer, Double> logitBias;
        private String user;

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public Double getTemperature() {
            return this.temperature;
        }

        public void setTemperature(Double temperature) {
            this.temperature = temperature;
        }

        public Double getTopP() {
            return this.topP;
        }

        public void setTopP(Double topP) {
            this.topP = topP;
        }

        public Integer getN() {
            return this.n;
        }

        public void setN(Integer n) {
            this.n = n;
        }

        public boolean isStream() {
            return this.stream;
        }

        public void setStream(boolean stream) {
            this.stream = stream;
        }

        public List<String> getStop() {
            return this.stop;
        }

        public void setStop(List<String> stop) {
            this.stop = stop;
        }

        public Integer getMaxPromptToken() {
            return this.maxPromptToken;
        }

        public void setMaxPromptToken(Integer maxPromptToken) {
            this.maxPromptToken = maxPromptToken;
        }

        public Integer getMaxCompletionToken() {
            return this.maxCompletionToken;
        }

        public void setMaxCompletionToken(Integer maxCompletionToken) {
            this.maxCompletionToken = maxCompletionToken;
        }

        public Double getPresencePenalty() {
            return this.presencePenalty;
        }

        public void setPresencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
        }

        public Double getFrequencyPenalty() {
            return this.frequencyPenalty;
        }

        public void setFrequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
        }

        public Map<Integer, Double> getLogitBias() {
            return this.logitBias;
        }

        public void setLogitBias(Map<Integer, Double> logitBias) {
            this.logitBias = logitBias;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }
    }

    public static class OpenAiModerationProperties {
        private String model;

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }
    }

    public static class OpenAiImageGenerationProperties
    extends OpenAiImageProperties {
    }

    public static class OpenAiImageEditProperties
    extends OpenAiImageProperties {
    }

    public static class OpenAiImageVariationProperties
    extends OpenAiImageProperties {
    }

    public static class OpenAiImageProperties {
        @Min(value=1L)
        @Max(value=10L)
        private @Min(value=1L) @Max(value=10L) Integer n;
        private String size;
        private String responseFormat;
        private String user;

        public Integer getN() {
            return this.n;
        }

        public void setN(Integer n) {
            this.n = n;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getResponseFormat() {
            return this.responseFormat;
        }

        public void setResponseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }
    }
}

