/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.pojo.chatcompletion;

import com.fasterxml.jackson.annotation.JsonProperty;
import cool.cena.openai.pojo.chatcompletion.ChatCompletionMessage;
import java.util.List;

public class OpenAiChatCompletionResponseBody {
    private String id;
    private String object;
    private String model;
    private Long created;
    private List<OpenAiChatCompletionResponseChoice> choices;
    private OpenAiChatCompletionResponseUsage usage;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public OpenAiChatCompletionResponseUsage getUsage() {
        return this.usage;
    }

    public void setUsage(OpenAiChatCompletionResponseUsage usage) {
        this.usage = usage;
    }

    public List<OpenAiChatCompletionResponseChoice> getChoices() {
        return this.choices;
    }

    public void setChoices(List<OpenAiChatCompletionResponseChoice> choices) {
        this.choices = choices;
    }

    public int getPromptToken() {
        return this.usage.getPromptTokens();
    }

    public int getCompletionToken() {
        return this.usage.getCompletionTokens();
    }

    public ChatCompletionMessage getObjectMessage() {
        return this.getObjectMessage(0);
    }

    public ChatCompletionMessage getObjectMessage(int choice) {
        return this.choices.get(choice).getMessage();
    }

    public String getMessage() {
        return this.getMessage(0);
    }

    public String getMessage(int choice) {
        return this.choices.get(choice).getMessage().getContent();
    }

    public static class OpenAiChatCompletionResponseUsage {
        @JsonProperty(value="prompt_tokens")
        private int promptTokens;
        @JsonProperty(value="completion_tokens")
        private int completionTokens;
        @JsonProperty(value="total_tokens")
        private int totalTokens;

        public int getPromptTokens() {
            return this.promptTokens;
        }

        public void setPromptTokens(int promptTokens) {
            this.promptTokens = promptTokens;
        }

        public int getCompletionTokens() {
            return this.completionTokens;
        }

        public void setCompletionTokens(int completionTokens) {
            this.completionTokens = completionTokens;
        }

        public int getTotalTokens() {
            return this.totalTokens;
        }

        public void setTotalTokens(int totalTokens) {
            this.totalTokens = totalTokens;
        }
    }

    public static class OpenAiChatCompletionResponseChoice {
        private int index;
        private ChatCompletionMessage message;
        @JsonProperty(value="finish_reason")
        private String finishReason;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public ChatCompletionMessage getMessage() {
            return this.message;
        }

        public void setMessage(ChatCompletionMessage message) {
            this.message = message;
        }

        public String getFinishReason() {
            return this.finishReason;
        }

        public void setFinishReason(String finishReason) {
            this.finishReason = finishReason;
        }
    }
}

