/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai;

import cool.cena.openai.exception.OpenAiUnauthorizedException;
import cool.cena.openai.exception.OpenAiUnknownException;
import cool.cena.openai.exception.audio.AudioResourceAccessException;
import cool.cena.openai.exception.audio.AudioStatusCodeException;
import cool.cena.openai.exception.chatcompletion.ChatCompletionBadRequestException;
import cool.cena.openai.exception.chatcompletion.ChatCompletionResourceAccessException;
import cool.cena.openai.exception.chatcompletion.ChatCompletionStatusCodeException;
import cool.cena.openai.exception.edit.EditResourceAccessException;
import cool.cena.openai.exception.edit.EditStatusCodeException;
import cool.cena.openai.exception.embedding.EmbeddingResourceAccessException;
import cool.cena.openai.exception.embedding.EmbeddingStatusCodeException;
import cool.cena.openai.exception.file.CreateFileResourceAccessException;
import cool.cena.openai.exception.file.CreateFileStatusCodeException;
import cool.cena.openai.exception.file.DeleteFileResourceAccessException;
import cool.cena.openai.exception.file.DeleteFileStatusCodeException;
import cool.cena.openai.exception.file.DownloadFileResourceAccessException;
import cool.cena.openai.exception.file.DownloadFileStatusCodeException;
import cool.cena.openai.exception.file.ListFileResourceAccessException;
import cool.cena.openai.exception.file.ListFileStatusCodeException;
import cool.cena.openai.exception.file.RetrieveFileResourceAccessException;
import cool.cena.openai.exception.file.RetrieveFileStatusCodeException;
import cool.cena.openai.exception.finetune.CancelFineTuneResourceAccessException;
import cool.cena.openai.exception.finetune.CancelFineTuneStatusCodeException;
import cool.cena.openai.exception.finetune.CreateFineTuneResourceAccessException;
import cool.cena.openai.exception.finetune.CreateFineTuneStatusCodeException;
import cool.cena.openai.exception.finetune.DeleteFineTuneResourceAccessException;
import cool.cena.openai.exception.finetune.DeleteFineTuneStatusCodeException;
import cool.cena.openai.exception.finetune.ListFineTuneEventsResourceAccessException;
import cool.cena.openai.exception.finetune.ListFineTuneEventsStatusCodeException;
import cool.cena.openai.exception.finetune.ListFineTuneResourceAccessException;
import cool.cena.openai.exception.finetune.ListFineTuneStatusCodeException;
import cool.cena.openai.exception.finetune.RetrieveFineTuneResourceAccessException;
import cool.cena.openai.exception.finetune.RetrieveFineTuneStatusCodeException;
import cool.cena.openai.exception.image.ImageBadRequestException;
import cool.cena.openai.exception.image.ImageResourceAccessException;
import cool.cena.openai.exception.image.ImageStatusCodeException;
import cool.cena.openai.exception.moderation.ModerationResourceAccessException;
import cool.cena.openai.exception.moderation.ModerationStatusCodeException;
import cool.cena.openai.exception.textcompletion.TextCompletionResourceAccessException;
import cool.cena.openai.exception.textcompletion.TextCompletionStatusCodeException;
import cool.cena.openai.pojo.audio.OpenAiAudioTranscriptionRequestBody;
import cool.cena.openai.pojo.audio.OpenAiAudioTranslationRequestBody;
import cool.cena.openai.pojo.chatcompletion.OpenAiChatCompletionRequestBody;
import cool.cena.openai.pojo.chatcompletion.OpenAiChatCompletionResponseBody;
import cool.cena.openai.pojo.edit.OpenAiEditRequestBody;
import cool.cena.openai.pojo.edit.OpenAiEditResponseBody;
import cool.cena.openai.pojo.embedding.OpenAiEmbeddingRequestBody;
import cool.cena.openai.pojo.embedding.OpenAiEmbeddingResponseBody;
import cool.cena.openai.pojo.file.OpenAiDeleteFileResponseBody;
import cool.cena.openai.pojo.file.OpenAiDownloadFileResponseBody;
import cool.cena.openai.pojo.file.OpenAiFile;
import cool.cena.openai.pojo.file.OpenAiFileRequestBody;
import cool.cena.openai.pojo.file.OpenAiListFileResponseBody;
import cool.cena.openai.pojo.finetune.OpenAiCancelFineTuneResponseBody;
import cool.cena.openai.pojo.finetune.OpenAiCreateFineTuneResponseBody;
import cool.cena.openai.pojo.finetune.OpenAiDeleteFineTuneResponseBody;
import cool.cena.openai.pojo.finetune.OpenAiFineTuneRequestBody;
import cool.cena.openai.pojo.finetune.OpenAiListFineTuneEventsResponseBody;
import cool.cena.openai.pojo.finetune.OpenAiListFineTuneResponseBody;
import cool.cena.openai.pojo.finetune.OpenAiRetrieveFineTuneResponseBody;
import cool.cena.openai.pojo.image.OpenAiImageEditRequestBody;
import cool.cena.openai.pojo.image.OpenAiImageEditResponseBody;
import cool.cena.openai.pojo.image.OpenAiImageGenerationRequestBody;
import cool.cena.openai.pojo.image.OpenAiImageGenerationResponseBody;
import cool.cena.openai.pojo.image.OpenAiImageVariationRequestBody;
import cool.cena.openai.pojo.image.OpenAiImageVariationResponseBody;
import cool.cena.openai.pojo.moderation.OpenAiModerationRequestBody;
import cool.cena.openai.pojo.moderation.OpenAiModerationResponseBody;
import cool.cena.openai.pojo.textcompletion.OpenAiTextCompletionRequestBody;
import cool.cena.openai.pojo.textcompletion.OpenAiTextCompletionResponseBody;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class OpenAiApiAccessor {
    private final String TEXT_COMPLETION_URL = "https://api.openai.com/v1/completions";
    private final String CHAT_COMPLETION_URL = "https://api.openai.com/v1/chat/completions";
    private final String EDIT_URL = "https://api.openai.com/v1/edits";
    private final String MODERATION_URL = "https://api.openai.com/v1/moderations";
    private final String IMAGE_GENERATION_URL = "https://api.openai.com/v1/images/generations";
    private final String IMAGE_EDIT_URL = "https://api.openai.com/v1/images/edits";
    private final String IMAGE_VARIATION_URL = "https://api.openai.com/v1/images/variations";
    private final String EMBEDDING_URL = "https://api.openai.com/v1/embeddings";
    private final String AUDIO_TRANSCRIPTION_URL = "https://api.openai.com/v1/audio/transcriptions";
    private final String AUDIO_TRANSLATION_URL = "https://api.openai.com/v1/audio/translations";
    private final String FILE_URL = "https://api.openai.com/v1/files";
    private final String FINE_TUNE_URL = "https://api.openai.com/v1/fine-tunes";
    private RestTemplate restTemplate;
    private HttpHeaders httpJsonHeaders;
    private HttpHeaders httpFileHeaders;

    public OpenAiApiAccessor(HttpHeaders httpHeaders) {
        HttpHeaders httpJsonHeaders = new HttpHeaders();
        httpJsonHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpJsonHeaders.addAll((MultiValueMap)httpHeaders);
        this.httpJsonHeaders = httpJsonHeaders;
        HttpHeaders httpFileHeaders = new HttpHeaders();
        httpFileHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        httpFileHeaders.addAll((MultiValueMap)httpHeaders);
        this.httpFileHeaders = httpFileHeaders;
        this.restTemplate = new RestTemplate();
    }

    public OpenAiTextCompletionResponseBody sendRequest(OpenAiTextCompletionRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)this.httpJsonHeaders);
        try {
            OpenAiTextCompletionResponseBody responseBody = (OpenAiTextCompletionResponseBody)this.restTemplate.postForObject(this.TEXT_COMPLETION_URL, (Object)requestEntity, OpenAiTextCompletionResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new TextCompletionStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new TextCompletionResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiChatCompletionResponseBody sendRequest(OpenAiChatCompletionRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)this.httpJsonHeaders);
        try {
            OpenAiChatCompletionResponseBody responseBody = (OpenAiChatCompletionResponseBody)this.restTemplate.postForObject(this.CHAT_COMPLETION_URL, (Object)requestEntity, OpenAiChatCompletionResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.BAD_REQUEST) {
                throw new ChatCompletionBadRequestException(e.getMessage());
            }
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new ChatCompletionStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new ChatCompletionResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiEditResponseBody sendRequest(OpenAiEditRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)this.httpJsonHeaders);
        try {
            OpenAiEditResponseBody responseBody = (OpenAiEditResponseBody)this.restTemplate.postForObject(this.EDIT_URL, (Object)requestEntity, OpenAiEditResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new EditStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new EditResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiModerationResponseBody sendRequest(OpenAiModerationRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)this.httpJsonHeaders);
        try {
            OpenAiModerationResponseBody responseBody = (OpenAiModerationResponseBody)this.restTemplate.postForObject(this.MODERATION_URL, (Object)requestEntity, OpenAiModerationResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new ModerationStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new ModerationResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiImageGenerationResponseBody sendRequest(OpenAiImageGenerationRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)this.httpJsonHeaders);
        try {
            OpenAiImageGenerationResponseBody responseBody = (OpenAiImageGenerationResponseBody)this.restTemplate.postForObject(this.IMAGE_GENERATION_URL, (Object)requestEntity, OpenAiImageGenerationResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new ImageStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new ImageResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiImageEditResponseBody sendRequest(OpenAiImageEditRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity(requestBody.toMultiValueMap(), (MultiValueMap)this.httpFileHeaders);
        try {
            OpenAiImageEditResponseBody responseBody = (OpenAiImageEditResponseBody)this.restTemplate.postForObject(this.IMAGE_EDIT_URL, (Object)requestEntity, OpenAiImageEditResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.BAD_REQUEST) {
                throw new ImageBadRequestException(e.getMessage());
            }
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new ImageStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new ImageResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiImageVariationResponseBody sendRequest(OpenAiImageVariationRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity(requestBody.toMultiValueMap(), (MultiValueMap)this.httpFileHeaders);
        try {
            OpenAiImageVariationResponseBody responseBody = (OpenAiImageVariationResponseBody)this.restTemplate.postForObject(this.IMAGE_VARIATION_URL, (Object)requestEntity, OpenAiImageVariationResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.BAD_REQUEST) {
                throw new ImageBadRequestException(e.getMessage());
            }
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new ImageStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new ImageResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiEmbeddingResponseBody sendRequest(OpenAiEmbeddingRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)this.httpJsonHeaders);
        try {
            OpenAiEmbeddingResponseBody responseBody = (OpenAiEmbeddingResponseBody)this.restTemplate.postForObject(this.EMBEDDING_URL, (Object)requestEntity, OpenAiEmbeddingResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new EmbeddingStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new EmbeddingResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public <T> T sendRequest(OpenAiAudioTranscriptionRequestBody requestBody, Class<T> responseClass) {
        HttpEntity requestEntity = new HttpEntity(requestBody.toMultiValueMap(), (MultiValueMap)this.httpFileHeaders);
        try {
            Object responseBody = this.restTemplate.postForObject(this.AUDIO_TRANSCRIPTION_URL, (Object)requestEntity, responseClass, new Object[0]);
            return (T)responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new AudioStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new AudioResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public <T> T sendRequest(OpenAiAudioTranslationRequestBody requestBody, Class<T> responseClass) {
        HttpEntity requestEntity = new HttpEntity(requestBody.toMultiValueMap(), (MultiValueMap)this.httpFileHeaders);
        try {
            Object responseBody = this.restTemplate.postForObject(this.AUDIO_TRANSLATION_URL, (Object)requestEntity, responseClass, new Object[0]);
            return (T)responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new AudioStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new AudioResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiListFileResponseBody listFiles() {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.FILE_URL, HttpMethod.GET, requestEntity, OpenAiListFileResponseBody.class, new Object[0]);
            return (OpenAiListFileResponseBody)responseEntity.getBody();
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new ListFileStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new ListFileResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiFile createFile(OpenAiFileRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity(requestBody.toMultiValueMap(), (MultiValueMap)this.httpFileHeaders);
        try {
            OpenAiFile responseBody = (OpenAiFile)this.restTemplate.postForObject("https://api.openai.com/v1/files", (Object)requestEntity, OpenAiFile.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new CreateFileStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new CreateFileResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiDeleteFileResponseBody deleteFile(String fileId) {
        String deleteFileUrl = this.FILE_URL + "/" + fileId;
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            ResponseEntity responseBody = this.restTemplate.exchange(deleteFileUrl, HttpMethod.DELETE, requestEntity, OpenAiDeleteFileResponseBody.class, new Object[0]);
            return (OpenAiDeleteFileResponseBody)responseBody.getBody();
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new DeleteFileStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new DeleteFileResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiFile retrieveFile(String fileId) {
        String retrieveFileUrl = this.FILE_URL + "/" + fileId;
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(retrieveFileUrl, HttpMethod.GET, requestEntity, OpenAiFile.class, new Object[0]);
            return (OpenAiFile)responseEntity.getBody();
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new RetrieveFileStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new RetrieveFileResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiDownloadFileResponseBody downloadFile(String fileId) {
        String retrieveFileContentUrl = this.FILE_URL + "/" + fileId + "/content";
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(retrieveFileContentUrl, HttpMethod.GET, requestEntity, String.class, new Object[0]);
            return new OpenAiDownloadFileResponseBody((String)responseEntity.getBody());
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new DownloadFileStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new DownloadFileResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiCreateFineTuneResponseBody sendRequest(OpenAiFineTuneRequestBody requestBody) {
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)this.httpJsonHeaders);
        try {
            OpenAiCreateFineTuneResponseBody responseBody = (OpenAiCreateFineTuneResponseBody)this.restTemplate.postForObject(this.FINE_TUNE_URL, (Object)requestEntity, OpenAiCreateFineTuneResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new CreateFineTuneStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new CreateFineTuneResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiListFineTuneResponseBody listFineTunes() {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(this.FILE_URL, HttpMethod.GET, requestEntity, OpenAiListFineTuneResponseBody.class, new Object[0]);
            return (OpenAiListFineTuneResponseBody)responseEntity.getBody();
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new ListFineTuneStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new ListFineTuneResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiRetrieveFineTuneResponseBody retrieveFineTune(String fineTuneId) {
        String retrieveFineTuneUrl = this.FINE_TUNE_URL + "/" + fineTuneId;
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(retrieveFineTuneUrl, HttpMethod.GET, requestEntity, OpenAiRetrieveFineTuneResponseBody.class, new Object[0]);
            return (OpenAiRetrieveFineTuneResponseBody)responseEntity.getBody();
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new RetrieveFineTuneStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new RetrieveFineTuneResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiCancelFineTuneResponseBody cancelFineTune(String fineTuneId) {
        String cancelFineTuneUrl = this.FINE_TUNE_URL + "/" + fineTuneId + "/cancel";
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            OpenAiCancelFineTuneResponseBody responseBody = (OpenAiCancelFineTuneResponseBody)this.restTemplate.postForObject(cancelFineTuneUrl, (Object)requestEntity, OpenAiCancelFineTuneResponseBody.class, new Object[0]);
            return responseBody;
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new CancelFineTuneStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new CancelFineTuneResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiListFineTuneEventsResponseBody listFineTuneEvents(String fineTuneId) {
        String listFineTuneEventsUrl = this.FINE_TUNE_URL + "/" + fineTuneId + "/events";
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(listFineTuneEventsUrl, HttpMethod.GET, requestEntity, OpenAiListFineTuneEventsResponseBody.class, new Object[0]);
            return (OpenAiListFineTuneEventsResponseBody)responseEntity.getBody();
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new ListFineTuneEventsStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new ListFineTuneEventsResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }

    public OpenAiDeleteFineTuneResponseBody deleteFineTune(String model) {
        String deleteFineTuneUrl = "https://api.openai.com/v1/models/" + model;
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpFileHeaders);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(deleteFineTuneUrl, HttpMethod.DELETE, requestEntity, OpenAiDeleteFineTuneResponseBody.class, new Object[0]);
            return (OpenAiDeleteFineTuneResponseBody)responseEntity.getBody();
        }
        catch (HttpStatusCodeException e) {
            HttpStatusCode httpStatusCode = e.getStatusCode();
            if (httpStatusCode == HttpStatus.UNAUTHORIZED) {
                throw new OpenAiUnauthorizedException(e.getMessage());
            }
            throw new DeleteFineTuneStatusCodeException(httpStatusCode, e.getMessage());
        }
        catch (ResourceAccessException e) {
            throw new DeleteFineTuneResourceAccessException(e.getMessage());
        }
        catch (RestClientException e) {
            throw new OpenAiUnknownException(e.getMessage());
        }
    }
}

