/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.context;

import cool.cena.openai.OpenAiApiAccessor;
import cool.cena.openai.autoconfigure.OpenAiProperties;
import cool.cena.openai.exception.audio.AudioFileInvalidException;
import cool.cena.openai.pojo.audio.OpenAiAudioTranscriptionRequestBody;
import cool.cena.openai.pojo.audio.OpenAiAudioTranscriptionResponseBody;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Base64;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class OpenAiAudioTranscriptionContext {
    private OpenAiApiAccessor apiAccessor;
    private OpenAiAudioTranscriptionRequestBody requestBody;

    public OpenAiAudioTranscriptionContext(OpenAiApiAccessor apiAccessor, OpenAiProperties.OpenAiAudioTranscriptionProperties audioTranscriptionProperties) {
        this.apiAccessor = apiAccessor;
        this.requestBody = new OpenAiAudioTranscriptionRequestBody(audioTranscriptionProperties);
    }

    public OpenAiAudioTranscriptionContext setModel(String model) {
        this.requestBody.setModel(model);
        return this;
    }

    public OpenAiAudioTranscriptionContext setTemperature(Double temperature) {
        this.requestBody.setTemperature(temperature);
        return this;
    }

    public OpenAiAudioTranscriptionContext setResponseFormat(String responseFormat) {
        this.requestBody.setResponseFormat(responseFormat);
        return this;
    }

    public OpenAiAudioTranscriptionContext setLanguage(String language) {
        this.requestBody.setLanguage(language);
        return this;
    }

    public OpenAiAudioTranscriptionResponseBody create(Object file) {
        Resource fileResource = this.resourcify(file);
        this.requestBody.setFile(fileResource);
        String responseFormat = this.requestBody.getResponseFormat();
        if (responseFormat.equals("text") || responseFormat.equals("srt") || responseFormat.equals("vtt")) {
            String responseText = this.apiAccessor.sendRequest(this.requestBody, String.class);
            OpenAiAudioTranscriptionResponseBody responseBody = new OpenAiAudioTranscriptionResponseBody();
            responseBody.setText(responseText);
            return responseBody;
        }
        return this.apiAccessor.sendRequest(this.requestBody, OpenAiAudioTranscriptionResponseBody.class);
    }

    public OpenAiAudioTranscriptionResponseBody create(Object file, String prompt) {
        this.requestBody.setPrompt(prompt);
        return this.create(file);
    }

    private Resource resourcify(Object audioObject) {
        if (audioObject instanceof String) {
            String audioString = (String)audioObject;
            try {
                byte[] audioBytes = Base64.getDecoder().decode((String)audioObject);
                return new ByteArrayResource(audioBytes);
            }
            catch (IllegalArgumentException e) {
                File audioFile = new File(audioString);
                if (audioFile.exists()) {
                    return new FileSystemResource(audioFile);
                }
                try {
                    return new UrlResource(audioString);
                }
                catch (MalformedURLException f) {
                    throw new AudioFileInvalidException(f.getMessage());
                }
            }
        }
        if (audioObject instanceof byte[]) {
            return new ByteArrayResource((byte[])audioObject);
        }
        if (audioObject instanceof File) {
            return new FileSystemResource((File)audioObject);
        }
        if (audioObject instanceof FileSystemResource) {
            return (FileSystemResource)audioObject;
        }
        if (audioObject instanceof UrlResource) {
            return (UrlResource)audioObject;
        }
        if (audioObject instanceof ByteArrayResource) {
            return (ByteArrayResource)audioObject;
        }
        throw new AudioFileInvalidException();
    }
}

