/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.context;

import cool.cena.openai.OpenAiApiAccessor;
import cool.cena.openai.autoconfigure.OpenAiProperties;
import cool.cena.openai.exception.audio.AudioFileInvalidException;
import cool.cena.openai.pojo.audio.OpenAiAudioTranslationRequestBody;
import cool.cena.openai.pojo.audio.OpenAiAudioTranslationResponseBody;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Base64;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class OpenAiAudioTranslationContext {
    private OpenAiApiAccessor apiAccessor;
    private OpenAiAudioTranslationRequestBody requestBody;

    public OpenAiAudioTranslationContext(OpenAiApiAccessor apiAccessor, OpenAiProperties.OpenAiAudioTranslationProperties audioTranslationProperties) {
        this.apiAccessor = apiAccessor;
        this.requestBody = new OpenAiAudioTranslationRequestBody(audioTranslationProperties);
    }

    public OpenAiAudioTranslationContext setModel(String model) {
        this.requestBody.setModel(model);
        return this;
    }

    public OpenAiAudioTranslationContext setTemperature(Double temperature) {
        this.requestBody.setTemperature(temperature);
        return this;
    }

    public OpenAiAudioTranslationContext setResponseFormat(String responseFormat) {
        this.requestBody.setResponseFormat(responseFormat);
        return this;
    }

    public OpenAiAudioTranslationResponseBody create(Object file) {
        Resource fileResource = this.resourcify(file);
        this.requestBody.setFile(fileResource);
        String responseFormat = this.requestBody.getResponseFormat();
        if (responseFormat.equals("text") || responseFormat.equals("srt") || responseFormat.equals("vtt")) {
            String responseText = this.apiAccessor.sendRequest(this.requestBody, String.class);
            OpenAiAudioTranslationResponseBody responseBody = new OpenAiAudioTranslationResponseBody();
            responseBody.setText(responseText);
            return responseBody;
        }
        return this.apiAccessor.sendRequest(this.requestBody, OpenAiAudioTranslationResponseBody.class);
    }

    public OpenAiAudioTranslationResponseBody create(Object file, String prompt) {
        this.requestBody.setPrompt(prompt);
        return this.create(file);
    }

    private Resource resourcify(Object audioObject) {
        if (audioObject instanceof String) {
            String audioString = (String)audioObject;
            try {
                byte[] audioBytes = Base64.getDecoder().decode((String)audioObject);
                return new ByteArrayResource(audioBytes);
            }
            catch (IllegalArgumentException e) {
                File audioFile = new File(audioString);
                if (audioFile.exists()) {
                    return new FileSystemResource(audioFile);
                }
                try {
                    return new UrlResource(audioString);
                }
                catch (MalformedURLException f) {
                    throw new AudioFileInvalidException(f.getMessage());
                }
            }
        }
        if (audioObject instanceof byte[]) {
            return new ByteArrayResource((byte[])audioObject);
        }
        if (audioObject instanceof File) {
            return new FileSystemResource((File)audioObject);
        }
        if (audioObject instanceof FileSystemResource) {
            return (FileSystemResource)audioObject;
        }
        if (audioObject instanceof UrlResource) {
            return (UrlResource)audioObject;
        }
        if (audioObject instanceof ByteArrayResource) {
            return (ByteArrayResource)audioObject;
        }
        throw new AudioFileInvalidException();
    }
}

