/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.context;

import cool.cena.openai.OpenAiApiAccessor;
import cool.cena.openai.autoconfigure.OpenAiProperties;
import cool.cena.openai.pojo.edit.OpenAiEditRequestBody;
import cool.cena.openai.pojo.edit.OpenAiEditResponseBody;

public class OpenAiEditContext {
    private OpenAiApiAccessor apiAccessor;
    private OpenAiEditRequestBody requestBody;

    public OpenAiEditContext(OpenAiApiAccessor apiAccessor, OpenAiProperties.OpenAiEditProperties openAiEditProperties) {
        this.apiAccessor = apiAccessor;
        this.requestBody = new OpenAiEditRequestBody(openAiEditProperties);
    }

    public OpenAiEditContext setModel(String model) {
        this.requestBody.setModel(model);
        return this;
    }

    public OpenAiEditContext setTemperature(Double temperature) {
        this.requestBody.setTemperature(temperature);
        return this;
    }

    public OpenAiEditContext setTopP(Double topP) {
        this.requestBody.setTopP(topP);
        return this;
    }

    public OpenAiEditContext setN(Integer n) {
        this.requestBody.setN(n);
        return this;
    }

    public OpenAiEditResponseBody create(String instruction) {
        return this.create("", instruction);
    }

    public OpenAiEditResponseBody create(String input, String instruction) {
        this.requestBody.setInput(input);
        this.requestBody.setInstruction(instruction);
        return this.apiAccessor.sendRequest(this.requestBody);
    }
}

