/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.context;

import cool.cena.openai.OpenAiApiAccessor;
import cool.cena.openai.autoconfigure.OpenAiProperties;
import cool.cena.openai.pojo.embedding.OpenAiEmbeddingRequestBody;
import cool.cena.openai.pojo.embedding.OpenAiEmbeddingResponseBody;
import java.util.List;

public class OpenAiEmbeddingContext {
    private OpenAiApiAccessor apiAccessor;
    private OpenAiEmbeddingRequestBody requestBody;

    public OpenAiEmbeddingContext(OpenAiApiAccessor apiAccessor, OpenAiProperties.OpenAiEmbeddingProperties openAiEmbeddingProperties) {
        this.apiAccessor = apiAccessor;
        this.requestBody = new OpenAiEmbeddingRequestBody(openAiEmbeddingProperties);
    }

    public OpenAiEmbeddingContext setModel(String model) {
        this.requestBody.setModel(model);
        return this;
    }

    public OpenAiEmbeddingContext setUser(String user) {
        this.requestBody.setUser(user);
        return this;
    }

    public OpenAiEmbeddingResponseBody create(String input) {
        this.requestBody.setInput(input);
        return this.apiAccessor.sendRequest(this.requestBody);
    }

    public OpenAiEmbeddingResponseBody create(List<Integer> input) {
        this.requestBody.setInput(input);
        return this.apiAccessor.sendRequest(this.requestBody);
    }
}

