/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.context;

import cool.cena.openai.OpenAiApiAccessor;
import cool.cena.openai.exception.file.FileInvalidException;
import cool.cena.openai.pojo.file.OpenAiDeleteFileResponseBody;
import cool.cena.openai.pojo.file.OpenAiDownloadFileResponseBody;
import cool.cena.openai.pojo.file.OpenAiFile;
import cool.cena.openai.pojo.file.OpenAiFileRequestBody;
import cool.cena.openai.pojo.file.OpenAiListFileResponseBody;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Base64;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class OpenAiFileContext {
    private OpenAiApiAccessor apiAccessor;

    public OpenAiFileContext(OpenAiApiAccessor apiAccessor) {
        this.apiAccessor = apiAccessor;
    }

    public OpenAiListFileResponseBody listFiles() {
        return this.apiAccessor.listFiles();
    }

    public OpenAiFile createFile(Object file, String purpose) {
        Resource fileResource = this.resourcify(file);
        OpenAiFileRequestBody requestBody = new OpenAiFileRequestBody();
        requestBody.setFile(fileResource);
        requestBody.setPurpose(purpose);
        return this.apiAccessor.createFile(requestBody);
    }

    public OpenAiDeleteFileResponseBody deleteFile(String fileId) {
        return this.apiAccessor.deleteFile(fileId);
    }

    public OpenAiFile retrieveFile(String fileId) {
        return this.apiAccessor.retrieveFile(fileId);
    }

    public OpenAiDownloadFileResponseBody downloadFile(String fileId) {
        return this.apiAccessor.downloadFile(fileId);
    }

    private Resource resourcify(Object fileObject) {
        if (fileObject instanceof String) {
            String fileString = (String)fileObject;
            try {
                byte[] fileBytes = Base64.getDecoder().decode((String)fileObject);
                return new ByteArrayResource(fileBytes);
            }
            catch (IllegalArgumentException e) {
                File file = new File(fileString);
                if (file.exists()) {
                    return new FileSystemResource(file);
                }
                try {
                    return new UrlResource(fileString);
                }
                catch (MalformedURLException f) {
                    throw new FileInvalidException(f.getMessage());
                }
            }
        }
        if (fileObject instanceof File) {
            return new FileSystemResource((File)fileObject);
        }
        if (fileObject instanceof FileSystemResource) {
            return (FileSystemResource)fileObject;
        }
        if (fileObject instanceof UrlResource) {
            return (UrlResource)fileObject;
        }
        if (fileObject instanceof ByteArrayResource) {
            return (ByteArrayResource)fileObject;
        }
        throw new FileInvalidException();
    }
}

