/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.context;

import cool.cena.openai.OpenAiApiAccessor;
import cool.cena.openai.autoconfigure.OpenAiProperties;
import cool.cena.openai.exception.image.ImageFileInvalidException;
import cool.cena.openai.pojo.image.OpenAiImageVariationRequestBody;
import cool.cena.openai.pojo.image.OpenAiImageVariationResponseBody;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Base64;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class OpenAiImageVariationContext {
    private OpenAiApiAccessor apiAccessor;
    private OpenAiImageVariationRequestBody requestBody;

    public OpenAiImageVariationContext(OpenAiApiAccessor apiAccessor, OpenAiProperties.OpenAiImageVariationProperties openAiImageVariationProperties) {
        this.apiAccessor = apiAccessor;
        this.requestBody = new OpenAiImageVariationRequestBody(openAiImageVariationProperties);
    }

    public OpenAiImageVariationContext setN(Integer n) {
        this.requestBody.setN(n);
        return this;
    }

    public OpenAiImageVariationContext setSize(String size) {
        this.requestBody.setSize(size);
        return this;
    }

    public OpenAiImageVariationContext setResponseFormat(String responseFormat) {
        this.requestBody.setResponseFormat(responseFormat);
        return this;
    }

    public OpenAiImageVariationContext setUser(String user) {
        this.requestBody.setUser(user);
        return this;
    }

    public OpenAiImageVariationResponseBody create(Object image) {
        Resource imageResource = this.resourcify(image);
        this.requestBody.setImage(imageResource);
        return this.apiAccessor.sendRequest(this.requestBody);
    }

    private Resource resourcify(Object imageObject) {
        if (imageObject instanceof String) {
            String imageString = (String)imageObject;
            try {
                byte[] imageBytes = Base64.getDecoder().decode((String)imageObject);
                return new ByteArrayResource(imageBytes);
            }
            catch (IllegalArgumentException e) {
                File imageFile = new File(imageString);
                if (imageFile.exists()) {
                    return new FileSystemResource(imageFile);
                }
                try {
                    return new UrlResource(imageString);
                }
                catch (MalformedURLException f) {
                    throw new ImageFileInvalidException(f.getMessage());
                }
            }
        }
        if (imageObject instanceof File) {
            return new FileSystemResource((File)imageObject);
        }
        if (imageObject instanceof FileSystemResource) {
            return (FileSystemResource)imageObject;
        }
        if (imageObject instanceof UrlResource) {
            return (UrlResource)imageObject;
        }
        if (imageObject instanceof ByteArrayResource) {
            return (ByteArrayResource)imageObject;
        }
        throw new ImageFileInvalidException();
    }
}

