/*
 * Decompiled with CFR 0.152.
 */
package cool.cena.openai.pojo.edit;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class OpenAiEditResponseBody {
    private String object;
    private Long created;
    private List<OpenAiEditResponseChoice> choices;
    private OpenAiEditResponseUsage usage;

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public OpenAiEditResponseUsage getUsage() {
        return this.usage;
    }

    public void setUsage(OpenAiEditResponseUsage usage) {
        this.usage = usage;
    }

    public List<OpenAiEditResponseChoice> getChoices() {
        return this.choices;
    }

    public void setChoices(List<OpenAiEditResponseChoice> choices) {
        this.choices = choices;
    }

    public int getPromptTokens() {
        return this.usage.getPromptTokens();
    }

    public int getCompletionTokens() {
        return this.usage.getCompletionTokens();
    }

    public String getText() {
        return this.getText(0);
    }

    public String getText(int choice) {
        return this.choices.get(choice).getText();
    }

    public static class OpenAiEditResponseUsage {
        @JsonProperty(value="prompt_tokens")
        private int promptTokens;
        @JsonProperty(value="completion_tokens")
        private int completionTokens;
        @JsonProperty(value="total_tokens")
        private int totalTokens;

        public int getPromptTokens() {
            return this.promptTokens;
        }

        public void setPromptTokens(int promptTokens) {
            this.promptTokens = promptTokens;
        }

        public int getCompletionTokens() {
            return this.completionTokens;
        }

        public void setCompletionTokens(int completionTokens) {
            this.completionTokens = completionTokens;
        }

        public int getTotalTokens() {
            return this.totalTokens;
        }

        public void setTotalTokens(int totalTokens) {
            this.totalTokens = totalTokens;
        }
    }

    public static class OpenAiEditResponseChoice {
        private int index;
        private String text;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

