/*
 * Copyright (c) 2024 Liang Wenjian
 * magicall is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package cool.document.qtmd;

public class ActivateState extends NotStartState implements MiddleState {
	public ActivateState(final State preState, final Object activateChars) {
		super(preState);
		buffer.append(activateChars);//buffer可能是一堆空白字符，最后一个\
	}

	@Override
	public State metActivateChar(final char activateChar) {
		return new MultiEscapeState(preState, buffer);
	}

	@Override
	public State metNewline(final char newlineChar) {
		return finish(newlineChar);
	}

	@Override
	public boolean isFinishChar(final char c) {
		return !Helper.maybeFlag(String.valueOf(c));
	}

	@Override
	public State metOtherChar(final char c) {
		return switch (c) {
			case '[' -> metLeftSquareBracket(c);
			case '#' -> metHash(c);
			case '.' -> metDot(c);
			case 'l', 'L' -> new MaybeLinkState(preState, c, buffer);
			case 'i', 'I' -> new IState(preState, c, buffer);
			case 'b', 'B' -> new BState(preState, c, buffer);
			default -> new MaybeFlagState(preState, String.valueOf(c), buffer);
		};
	}

	protected TableState metLeftSquareBracket(final char c) {
		return new TableState(preState, c);
	}

	protected HashState metHash(final char c) {
		return new HashState(preState, buffer, c);
	}

	protected MaybeLiState metDot(final char c) {
		return new MaybeLiState(preState, buffer, c);
	}

	//==========================================================

	/**
	 * 多转义符状态。简单起见，多转义符视为普通文本，此时不再接受标记。
	 */
	public static class MultiEscapeState extends NotStartState implements MiddleState {
		public MultiEscapeState(final State preState, final StringBuilder initBuffer) {
			super(preState, initBuffer);
		}

		@Override
		public State metNewline(final char newlineChar) {
			return finish(newlineChar);
		}

		@Override
		public State metActivateChar(final char activateChar) {
			return addChar(activateChar);
		}

		@Override
		public boolean isFinishChar(final char c) {
			return c != '\\';
		}
	}
}
